/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.connection;

import java.nio.channels.AsynchronousChannelGroup;
import net.zaiyers.Channels.lib.mongodb.ServerAddress;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.SocketSettings;
import net.zaiyers.Channels.lib.mongodb.connection.SslSettings;
import net.zaiyers.Channels.lib.mongodb.connection.Stream;
import net.zaiyers.Channels.lib.mongodb.connection.StreamFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.AsynchronousSocketChannelStream;
import net.zaiyers.Channels.lib.mongodb.internal.connection.PowerOfTwoBufferPool;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final PowerOfTwoBufferPool bufferProvider = PowerOfTwoBufferPool.DEFAULT;
    private final SocketSettings settings;
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings, @Nullable AsynchronousChannelGroup group) {
        if (sslSettings.isEnabled()) {
            throw new UnsupportedOperationException("No SSL support in java.nio.channels.AsynchronousSocketChannel. For SSL support use com.mongodb.connection.TlsChannelStreamFactoryFactory");
        }
        this.settings = Assertions.notNull("settings", settings);
        this.group = group;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new AsynchronousSocketChannelStream(serverAddress, this.settings, this.bufferProvider, this.group);
    }
}

