/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.model.search;

import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.bson.conversions.Bson;
import net.zaiyers.Channels.lib.mongodb.annotations.Beta;
import net.zaiyers.Channels.lib.mongodb.annotations.Evolving;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.search.FacetSearchCollector;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchConstructibleBsonElement;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchFacet;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchOperator;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchCollector
extends Bson {
    @Beta(value={Beta.Reason.CLIENT, Beta.Reason.SERVER})
    public static FacetSearchCollector facet(SearchOperator operator, Iterable<? extends SearchFacet> facets) {
        Assertions.notNull("operator", operator);
        Assertions.notNull("facets", facets);
        return new SearchConstructibleBsonElement("facet", (Bson)new Document("operator", operator).append("facets", SearchFacet.combineToBson(facets)));
    }

    public static SearchCollector of(Bson collector) {
        return new SearchConstructibleBsonElement(Assertions.notNull("collector", collector));
    }
}

