/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.model.mql;

import java.util.Collections;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import net.zaiyers.Channels.lib.bson.BsonArray;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonInt32;
import net.zaiyers.Channels.lib.bson.BsonString;
import net.zaiyers.Channels.lib.bson.BsonValue;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.Branches;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.BranchesTerminal;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlArray;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlBoolean;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlDate;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlDocument;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlEntry;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlInteger;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlMap;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlNumber;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlString;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlValue;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.MqlValues;
import net.zaiyers.Channels.lib.mongodb.client.model.mql.SwitchCase;

final class MqlExpression<T extends MqlValue>
implements MqlValue,
MqlBoolean,
MqlInteger,
MqlNumber,
MqlString,
MqlDate,
MqlDocument,
MqlArray<T>,
MqlMap<T>,
MqlEntry<T> {
    private final Function<CodecRegistry, AstPlaceholder> fn;

    MqlExpression(Function<CodecRegistry, AstPlaceholder> fn) {
        this.fn = fn;
    }

    BsonValue toBsonValue(CodecRegistry codecRegistry) {
        return this.fn.apply(codecRegistry).bsonValue;
    }

    private AstPlaceholder astDoc(String name, BsonDocument value) {
        return new AstPlaceholder(new BsonDocument(name, value));
    }

    @Override
    public MqlString getKey() {
        return new MqlExpression<T>(this.getFieldInternal("k"));
    }

    @Override
    public T getValue() {
        return (T)MqlExpression.newMqlExpression(this.getFieldInternal("v"));
    }

    @Override
    public MqlEntry<T> setValue(T value) {
        Assertions.notNull("value", value);
        return this.setFieldInternal("v", (MqlValue)value);
    }

    @Override
    public MqlEntry<T> setKey(MqlString key) {
        Assertions.notNull("key", key);
        return this.setFieldInternal("k", key);
    }

    private Function<CodecRegistry, AstPlaceholder> ast(String name) {
        return cr -> new AstPlaceholder(new BsonDocument(name, this.toBsonValue((CodecRegistry)cr)));
    }

    private Function<CodecRegistry, AstPlaceholder> astWrapped(String name) {
        return cr -> new AstPlaceholder(new BsonDocument(name, new BsonArray(Collections.singletonList(this.toBsonValue((CodecRegistry)cr)))));
    }

    private Function<CodecRegistry, AstPlaceholder> ast(String name, MqlValue param1) {
        return cr -> {
            BsonArray value = new BsonArray();
            value.add(this.toBsonValue((CodecRegistry)cr));
            value.add(MqlExpression.toBsonValue(cr, param1));
            return new AstPlaceholder(new BsonDocument(name, value));
        };
    }

    private Function<CodecRegistry, AstPlaceholder> ast(String name, MqlValue param1, MqlValue param2) {
        return cr -> {
            BsonArray value = new BsonArray();
            value.add(this.toBsonValue((CodecRegistry)cr));
            value.add(MqlExpression.toBsonValue(cr, param1));
            value.add(MqlExpression.toBsonValue(cr, param2));
            return new AstPlaceholder(new BsonDocument(name, value));
        };
    }

    static BsonValue toBsonValue(CodecRegistry cr, MqlValue mqlValue) {
        return ((MqlExpression)mqlValue).toBsonValue(cr);
    }

    <R extends MqlValue> R assertImplementsAllExpressions() {
        return (R)this;
    }

    private static <R extends MqlValue> R newMqlExpression(Function<CodecRegistry, AstPlaceholder> ast) {
        return new MqlExpression(ast).assertImplementsAllExpressions();
    }

    private <R extends MqlValue> R variable(String variable) {
        return MqlExpression.newMqlExpression(cr -> new AstPlaceholder(new BsonString(variable)));
    }

    @Override
    public MqlBoolean not() {
        return new MqlExpression<T>(this.ast("$not"));
    }

    @Override
    public MqlBoolean or(MqlBoolean other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$or", other));
    }

    @Override
    public MqlBoolean and(MqlBoolean other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$and", other));
    }

    public <R extends MqlValue> R cond(R ifTrue, R ifFalse) {
        Assertions.notNull("ifTrue", ifTrue);
        Assertions.notNull("ifFalse", ifFalse);
        return MqlExpression.newMqlExpression(this.ast("$cond", ifTrue, ifFalse));
    }

    private Function<CodecRegistry, AstPlaceholder> getFieldInternal(String fieldName) {
        return cr -> {
            BsonValue value = fieldName.startsWith("$") ? new BsonDocument("$literal", new BsonString(fieldName)) : new BsonString(fieldName);
            return this.astDoc("$getField", new BsonDocument().append("input", this.fn.apply((CodecRegistry)cr).bsonValue).append("field", value));
        };
    }

    @Override
    public MqlValue getField(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    @Override
    public MqlBoolean getBoolean(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    @Override
    public MqlBoolean getBoolean(String fieldName, MqlBoolean other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getBoolean(fieldName).isBooleanOr(other);
    }

    @Override
    public MqlNumber getNumber(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    @Override
    public MqlNumber getNumber(String fieldName, MqlNumber other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getNumber(fieldName).isNumberOr(other);
    }

    @Override
    public MqlInteger getInteger(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    @Override
    public MqlInteger getInteger(String fieldName, MqlInteger other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getInteger(fieldName).isIntegerOr(other);
    }

    @Override
    public MqlString getString(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    @Override
    public MqlString getString(String fieldName, MqlString other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getString(fieldName).isStringOr(other);
    }

    @Override
    public MqlDate getDate(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    @Override
    public MqlDate getDate(String fieldName, MqlDate other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getDate(fieldName).isDateOr(other);
    }

    @Override
    public MqlDocument getDocument(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    public <R extends MqlValue> MqlMap<R> getMap(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    public <R extends MqlValue> MqlMap<R> getMap(String fieldName, MqlMap<? extends R> other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getMap(fieldName).isMapOr(other);
    }

    @Override
    public MqlDocument getDocument(String fieldName, MqlDocument other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getDocument(fieldName).isDocumentOr(other);
    }

    public <R extends MqlValue> MqlArray<R> getArray(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return new MqlExpression<T>(this.getFieldInternal(fieldName));
    }

    public <R extends MqlValue> MqlArray<R> getArray(String fieldName, MqlArray<? extends R> other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getArray(fieldName).isArrayOr(other);
    }

    @Override
    public MqlDocument merge(MqlDocument other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$mergeObjects", other));
    }

    @Override
    public MqlDocument setField(String fieldName, MqlValue value) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("value", value);
        return this.setFieldInternal(fieldName, value);
    }

    private MqlExpression<T> setFieldInternal(String fieldName, MqlValue value) {
        Assertions.notNull("fieldName", fieldName);
        return (MqlExpression)MqlExpression.newMqlExpression(cr -> this.astDoc("$setField", new BsonDocument().append("field", new BsonString(fieldName)).append("input", this.toBsonValue((CodecRegistry)cr)).append("value", MqlExpression.toBsonValue(cr, value))));
    }

    @Override
    public MqlDocument unsetField(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return (MqlDocument)MqlExpression.newMqlExpression(cr -> this.astDoc("$unsetField", new BsonDocument().append("field", new BsonString(fieldName)).append("input", this.toBsonValue((CodecRegistry)cr))));
    }

    @Override
    public <R extends MqlValue> R passTo(Function<? super MqlValue, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlValue)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchOn(Function<Branches<MqlValue>, ? extends BranchesTerminal<MqlValue, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlValue)this.assertImplementsAllExpressions(), (BranchesTerminal)mapping.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passBooleanTo(Function<? super MqlBoolean, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlBoolean)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchBooleanOn(Function<Branches<MqlBoolean>, ? extends BranchesTerminal<MqlBoolean, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlBoolean)this.assertImplementsAllExpressions(), mapping.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passIntegerTo(Function<? super MqlInteger, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlInteger)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchIntegerOn(Function<Branches<MqlInteger>, ? extends BranchesTerminal<MqlInteger, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlInteger)this.assertImplementsAllExpressions(), mapping.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passNumberTo(Function<? super MqlNumber, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlNumber)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchNumberOn(Function<Branches<MqlNumber>, ? extends BranchesTerminal<MqlNumber, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlNumber)this.assertImplementsAllExpressions(), mapping.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passStringTo(Function<? super MqlString, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlString)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchStringOn(Function<Branches<MqlString>, ? extends BranchesTerminal<MqlString, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlString)this.assertImplementsAllExpressions(), mapping.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passDateTo(Function<? super MqlDate, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlDate)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchDateOn(Function<Branches<MqlDate>, ? extends BranchesTerminal<MqlDate, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlDate)this.assertImplementsAllExpressions(), mapping.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passArrayTo(Function<? super MqlArray<T>, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlArray<R>)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchArrayOn(Function<Branches<MqlArray<T>>, ? extends BranchesTerminal<MqlArray<T>, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlArray)this.assertImplementsAllExpressions(), mapping.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passMapTo(Function<? super MqlMap<T>, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlMap<R>)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchMapOn(Function<Branches<MqlMap<T>>, ? extends BranchesTerminal<MqlMap<T>, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlMap)this.assertImplementsAllExpressions(), mapping.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passDocumentTo(Function<? super MqlDocument, ? extends R> f) {
        Assertions.notNull("f", f);
        return (R)((MqlValue)f.apply((MqlDocument)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchDocumentOn(Function<Branches<MqlDocument>, ? extends BranchesTerminal<MqlDocument, ? extends R>> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.switchMapInternal((MqlDocument)this.assertImplementsAllExpressions(), mapping.apply(new Branches()));
    }

    private <T0 extends MqlValue, R0 extends MqlValue> R0 switchMapInternal(T0 value, BranchesTerminal<T0, R0> construct) {
        return (R0)MqlExpression.newMqlExpression(cr -> {
            BsonArray branches = new BsonArray();
            for (Function function : construct.getBranches()) {
                SwitchCase result = function.apply(value);
                branches.add(new BsonDocument().append("case", MqlExpression.toBsonValue(cr, result.getCaseValue())).append("then", MqlExpression.toBsonValue(cr, result.getThenValue())));
            }
            BsonDocument switchBson = new BsonDocument().append("branches", branches);
            if (construct.getDefaults() != null) {
                switchBson = switchBson.append("default", MqlExpression.toBsonValue(cr, (MqlValue)construct.getDefaults().apply(value)));
            }
            return this.astDoc("$switch", switchBson);
        });
    }

    @Override
    public MqlBoolean eq(MqlValue other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$eq", other));
    }

    @Override
    public MqlBoolean ne(MqlValue other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$ne", other));
    }

    @Override
    public MqlBoolean gt(MqlValue other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$gt", other));
    }

    @Override
    public MqlBoolean gte(MqlValue other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$gte", other));
    }

    @Override
    public MqlBoolean lt(MqlValue other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$lt", other));
    }

    @Override
    public MqlBoolean lte(MqlValue other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$lte", other));
    }

    MqlBoolean isBoolean() {
        return new MqlExpression<T>(this.astWrapped("$type")).eq(MqlValues.of("bool"));
    }

    @Override
    public MqlBoolean isBooleanOr(MqlBoolean other) {
        Assertions.notNull("other", other);
        return this.isBoolean().cond(this, other);
    }

    MqlBoolean isNumber() {
        return new MqlExpression<T>(this.astWrapped("$isNumber"));
    }

    @Override
    public MqlNumber isNumberOr(MqlNumber other) {
        Assertions.notNull("other", other);
        return this.isNumber().cond(this, other);
    }

    MqlBoolean isInteger() {
        return (MqlBoolean)this.switchOn(on -> on.isNumber(v -> v.round().eq((MqlValue)v)).defaults(v -> MqlValues.of(false)));
    }

    @Override
    public MqlInteger isIntegerOr(MqlInteger other) {
        Assertions.notNull("other", other);
        return (MqlInteger)this.switchOn(on -> on.isNumber(v -> v.round().eq((MqlValue)v).cond(v, other)).defaults(v -> other));
    }

    MqlBoolean isString() {
        return new MqlExpression<T>(this.astWrapped("$type")).eq(MqlValues.of("string"));
    }

    @Override
    public MqlString isStringOr(MqlString other) {
        Assertions.notNull("other", other);
        return this.isString().cond(this, other);
    }

    MqlBoolean isDate() {
        return MqlValues.ofStringArray("date").contains(new MqlExpression<T>(this.astWrapped("$type")));
    }

    @Override
    public MqlDate isDateOr(MqlDate other) {
        Assertions.notNull("other", other);
        return this.isDate().cond(this, other);
    }

    MqlBoolean isArray() {
        return new MqlExpression<T>(this.astWrapped("$isArray"));
    }

    public <R extends MqlValue> MqlArray<R> isArrayOr(MqlArray<? extends R> other) {
        Assertions.notNull("other", other);
        return this.isArray().cond((MqlArray)this.assertImplementsAllExpressions(), other);
    }

    MqlBoolean isDocumentOrMap() {
        return new MqlExpression<T>(this.astWrapped("$type")).eq(MqlValues.of("object"));
    }

    public <R extends MqlDocument> R isDocumentOr(R other) {
        Assertions.notNull("other", other);
        return (R)this.isDocumentOrMap().cond((MqlDocument)this.assertImplementsAllExpressions(), other);
    }

    public <R extends MqlValue> MqlMap<R> isMapOr(MqlMap<? extends R> other) {
        Assertions.notNull("other", other);
        MqlExpression isMap = (MqlExpression)this.isDocumentOrMap();
        return (MqlMap)MqlExpression.newMqlExpression(isMap.ast("$cond", (MqlValue)this.assertImplementsAllExpressions(), other));
    }

    MqlBoolean isNull() {
        return this.eq(MqlValues.ofNull());
    }

    @Override
    public MqlString asString() {
        return new MqlExpression<T>(this.astWrapped("$toString"));
    }

    private Function<CodecRegistry, AstPlaceholder> convertInternal(String to, MqlValue other) {
        return cr -> this.astDoc("$convert", new BsonDocument().append("input", this.fn.apply((CodecRegistry)cr).bsonValue).append("onError", MqlExpression.toBsonValue(cr, other)).append("to", new BsonString(to)));
    }

    @Override
    public MqlInteger parseInteger() {
        MqlExpression<T> asLong = new MqlExpression<T>(this.ast("$toLong"));
        return new MqlExpression<T>(this.convertInternal("int", asLong));
    }

    @Override
    public <R extends MqlValue> MqlArray<R> map(Function<? super T, ? extends R> in) {
        Assertions.notNull("in", in);
        Object varThis = this.variable("$$this");
        return new MqlExpression<T>(cr -> this.astDoc("$map", new BsonDocument().append("input", this.toBsonValue((CodecRegistry)cr)).append("in", MqlExpression.toBsonValue(cr, (MqlValue)in.apply((T)varThis)))));
    }

    @Override
    public MqlArray<T> filter(Function<? super T, ? extends MqlBoolean> predicate) {
        Assertions.notNull("predicate", predicate);
        Object varThis = this.variable("$$this");
        return new MqlExpression<T>(cr -> this.astDoc("$filter", new BsonDocument().append("input", this.toBsonValue((CodecRegistry)cr)).append("cond", MqlExpression.toBsonValue(cr, (MqlValue)predicate.apply((T)varThis)))));
    }

    MqlArray<T> sort() {
        return new MqlExpression<T>(cr -> this.astDoc("$sortArray", new BsonDocument().append("input", this.toBsonValue((CodecRegistry)cr)).append("sortBy", new BsonInt32(1))));
    }

    private T reduce(T initialValue, BinaryOperator<T> in) {
        Object varThis = this.variable("$$this");
        Object varValue = this.variable("$$value");
        return (T)MqlExpression.newMqlExpression(cr -> this.astDoc("$reduce", new BsonDocument().append("input", this.toBsonValue((CodecRegistry)cr)).append("initialValue", MqlExpression.toBsonValue(cr, initialValue)).append("in", MqlExpression.toBsonValue(cr, (MqlValue)in.apply(varValue, varThis)))));
    }

    @Override
    public MqlBoolean any(Function<? super T, MqlBoolean> predicate) {
        Assertions.notNull("predicate", predicate);
        MqlExpression array = (MqlExpression)this.map(predicate);
        return array.reduce(MqlValues.of(false), (a, b) -> a.or((MqlBoolean)b));
    }

    @Override
    public MqlBoolean all(Function<? super T, MqlBoolean> predicate) {
        Assertions.notNull("predicate", predicate);
        MqlExpression array = (MqlExpression)this.map(predicate);
        return array.reduce(MqlValues.of(true), (a, b) -> a.and((MqlBoolean)b));
    }

    @Override
    public MqlNumber sum(Function<? super T, ? extends MqlNumber> mapper) {
        Assertions.notNull("mapper", mapper);
        MqlExpression array = (MqlExpression)this.map(mapper);
        return array.reduce(MqlValues.of(0), (a, b) -> a.add((MqlNumber)b));
    }

    @Override
    public MqlNumber multiply(Function<? super T, ? extends MqlNumber> mapper) {
        Assertions.notNull("mapper", mapper);
        MqlExpression array = (MqlExpression)this.map(mapper);
        return array.reduce(MqlValues.of(1), (a, b) -> a.multiply((MqlNumber)b));
    }

    @Override
    public T max(T other) {
        Assertions.notNull("other", other);
        return this.size().eq(MqlValues.of(0)).cond(other, this.maxN(MqlValues.of(1)).first());
    }

    @Override
    public T min(T other) {
        Assertions.notNull("other", other);
        return this.size().eq(MqlValues.of(0)).cond(other, this.minN(MqlValues.of(1)).first());
    }

    @Override
    public MqlArray<T> maxN(MqlInteger n) {
        Assertions.notNull("n", n);
        return (MqlArray)MqlExpression.newMqlExpression(cr -> this.astDoc("$maxN", new BsonDocument().append("input", MqlExpression.toBsonValue(cr, this)).append("n", MqlExpression.toBsonValue(cr, n))));
    }

    @Override
    public MqlArray<T> minN(MqlInteger n) {
        Assertions.notNull("n", n);
        return (MqlArray)MqlExpression.newMqlExpression(cr -> this.astDoc("$minN", new BsonDocument().append("input", MqlExpression.toBsonValue(cr, this)).append("n", MqlExpression.toBsonValue(cr, n))));
    }

    @Override
    public MqlString joinStrings(Function<? super T, MqlString> mapper) {
        Assertions.notNull("mapper", mapper);
        MqlExpression array = (MqlExpression)this.map(mapper);
        return array.reduce(MqlValues.of(""), (a, b) -> a.append((MqlString)b));
    }

    @Override
    public <R extends MqlValue> MqlArray<R> concatArrays(Function<? super T, ? extends MqlArray<? extends R>> mapper) {
        Assertions.notNull("mapper", mapper);
        MqlExpression array = (MqlExpression)this.map(mapper);
        return array.reduce(MqlValues.ofArray((MqlValue[])new MqlValue[0]), (a, b) -> a.concat(b));
    }

    @Override
    public <R extends MqlValue> MqlArray<R> unionArrays(Function<? super T, ? extends MqlArray<? extends R>> mapper) {
        Assertions.notNull("mapper", mapper);
        Assertions.notNull("mapper", mapper);
        MqlExpression array = (MqlExpression)this.map(mapper);
        return array.reduce(MqlValues.ofArray((MqlValue[])new MqlValue[0]), (a, b) -> a.union(b));
    }

    @Override
    public MqlInteger size() {
        return new MqlExpression<T>(this.astWrapped("$size"));
    }

    @Override
    public T elementAt(MqlInteger i) {
        Assertions.notNull("i", i);
        return (T)new MqlExpression<T>(this.ast("$arrayElemAt", i)).assertImplementsAllExpressions();
    }

    @Override
    public T first() {
        return (T)new MqlExpression<T>(this.astWrapped("$first")).assertImplementsAllExpressions();
    }

    @Override
    public T last() {
        return (T)new MqlExpression<T>(this.astWrapped("$last")).assertImplementsAllExpressions();
    }

    @Override
    public MqlBoolean contains(T value) {
        Assertions.notNull("value", value);
        String name = "$in";
        return (MqlBoolean)new MqlExpression<T>(cr -> {
            BsonArray array = new BsonArray();
            array.add(MqlExpression.toBsonValue(cr, value));
            array.add(this.toBsonValue((CodecRegistry)cr));
            return new AstPlaceholder(new BsonDocument(name, array));
        }).assertImplementsAllExpressions();
    }

    @Override
    public MqlArray<T> concat(MqlArray<? extends T> other) {
        Assertions.notNull("other", other);
        return (MqlArray)new MqlExpression<T>(this.ast("$concatArrays", other)).assertImplementsAllExpressions();
    }

    @Override
    public MqlArray<T> slice(MqlInteger start, MqlInteger length) {
        Assertions.notNull("start", start);
        Assertions.notNull("length", length);
        return (MqlArray)new MqlExpression<T>(this.ast("$slice", start, length)).assertImplementsAllExpressions();
    }

    @Override
    public MqlArray<T> union(MqlArray<? extends T> other) {
        Assertions.notNull("other", other);
        return (MqlArray)new MqlExpression<T>(this.ast("$setUnion", other)).assertImplementsAllExpressions();
    }

    @Override
    public MqlArray<T> distinct() {
        return new MqlExpression<T>(this.astWrapped("$setUnion"));
    }

    @Override
    public MqlInteger multiply(MqlNumber other) {
        Assertions.notNull("other", other);
        return (MqlInteger)MqlExpression.newMqlExpression(this.ast("$multiply", other));
    }

    @Override
    public MqlNumber add(MqlNumber other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$add", other));
    }

    @Override
    public MqlNumber divide(MqlNumber other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$divide", other));
    }

    @Override
    public MqlNumber max(MqlNumber other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$max", other));
    }

    @Override
    public MqlNumber min(MqlNumber other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$min", other));
    }

    @Override
    public MqlInteger round() {
        return new MqlExpression<T>(this.ast("$round"));
    }

    @Override
    public MqlNumber round(MqlInteger place) {
        Assertions.notNull("place", place);
        return new MqlExpression<T>(this.ast("$round", place));
    }

    @Override
    public MqlInteger multiply(MqlInteger other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$multiply", other));
    }

    @Override
    public MqlInteger abs() {
        return (MqlInteger)MqlExpression.newMqlExpression(this.ast("$abs"));
    }

    @Override
    public MqlDate millisecondsAsDate() {
        return (MqlDate)MqlExpression.newMqlExpression(this.ast("$toDate"));
    }

    @Override
    public MqlNumber subtract(MqlNumber other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$subtract", other));
    }

    @Override
    public MqlInteger add(MqlInteger other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$add", other));
    }

    @Override
    public MqlInteger subtract(MqlInteger other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$subtract", other));
    }

    @Override
    public MqlInteger max(MqlInteger other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$max", other));
    }

    @Override
    public MqlInteger min(MqlInteger other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$min", other));
    }

    private MqlExpression<MqlValue> usingTimezone(String name, MqlString timezone) {
        return new MqlExpression<MqlValue>(cr -> this.astDoc(name, new BsonDocument().append("date", this.toBsonValue((CodecRegistry)cr)).append("timezone", MqlExpression.toBsonValue(cr, timezone))));
    }

    @Override
    public MqlInteger year(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$year", timezone);
    }

    @Override
    public MqlInteger month(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$month", timezone);
    }

    @Override
    public MqlInteger dayOfMonth(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$dayOfMonth", timezone);
    }

    @Override
    public MqlInteger dayOfWeek(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$dayOfWeek", timezone);
    }

    @Override
    public MqlInteger dayOfYear(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$dayOfYear", timezone);
    }

    @Override
    public MqlInteger hour(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$hour", timezone);
    }

    @Override
    public MqlInteger minute(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$minute", timezone);
    }

    @Override
    public MqlInteger second(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$second", timezone);
    }

    @Override
    public MqlInteger week(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$week", timezone);
    }

    @Override
    public MqlInteger millisecond(MqlString timezone) {
        Assertions.notNull("timezone", timezone);
        return this.usingTimezone("$millisecond", timezone);
    }

    @Override
    public MqlString asString(MqlString timezone, MqlString format) {
        Assertions.notNull("timezone", timezone);
        Assertions.notNull("format", format);
        return (MqlString)MqlExpression.newMqlExpression(cr -> this.astDoc("$dateToString", new BsonDocument().append("date", this.toBsonValue((CodecRegistry)cr)).append("format", MqlExpression.toBsonValue(cr, format)).append("timezone", MqlExpression.toBsonValue(cr, timezone))));
    }

    @Override
    public MqlDate parseDate(MqlString timezone, MqlString format) {
        Assertions.notNull("timezone", timezone);
        Assertions.notNull("format", format);
        return (MqlDate)MqlExpression.newMqlExpression(cr -> this.astDoc("$dateFromString", new BsonDocument().append("dateString", this.toBsonValue((CodecRegistry)cr)).append("format", MqlExpression.toBsonValue(cr, format)).append("timezone", MqlExpression.toBsonValue(cr, timezone))));
    }

    @Override
    public MqlDate parseDate(MqlString format) {
        Assertions.notNull("format", format);
        return (MqlDate)MqlExpression.newMqlExpression(cr -> this.astDoc("$dateFromString", new BsonDocument().append("dateString", this.toBsonValue((CodecRegistry)cr)).append("format", MqlExpression.toBsonValue(cr, format))));
    }

    @Override
    public MqlDate parseDate() {
        return (MqlDate)MqlExpression.newMqlExpression(cr -> this.astDoc("$dateFromString", new BsonDocument().append("dateString", this.toBsonValue((CodecRegistry)cr))));
    }

    @Override
    public MqlString toLower() {
        return new MqlExpression<T>(this.ast("$toLower"));
    }

    @Override
    public MqlString toUpper() {
        return new MqlExpression<T>(this.ast("$toUpper"));
    }

    @Override
    public MqlString append(MqlString other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$concat", other));
    }

    @Override
    public MqlInteger length() {
        return new MqlExpression<T>(this.ast("$strLenCP"));
    }

    @Override
    public MqlInteger lengthBytes() {
        return new MqlExpression<T>(this.ast("$strLenBytes"));
    }

    @Override
    public MqlString substr(MqlInteger start, MqlInteger length) {
        Assertions.notNull("start", start);
        Assertions.notNull("length", length);
        return new MqlExpression<T>(this.ast("$substrCP", start, length));
    }

    @Override
    public MqlString substrBytes(MqlInteger start, MqlInteger length) {
        Assertions.notNull("start", start);
        Assertions.notNull("length", length);
        return new MqlExpression<T>(this.ast("$substrBytes", start, length));
    }

    @Override
    public MqlBoolean has(MqlString key) {
        Assertions.notNull("key", key);
        return this.get(key).ne((MqlValue)MqlExpression.ofRem());
    }

    @Override
    public MqlBoolean hasField(String fieldName) {
        Assertions.notNull("fieldName", fieldName);
        return this.has(MqlValues.of(fieldName));
    }

    static <R extends MqlValue> R ofRem() {
        return new MqlExpression(cr -> new AstPlaceholder(new BsonString("$$REMOVE"))).assertImplementsAllExpressions();
    }

    @Override
    public T get(MqlString key) {
        Assertions.notNull("key", key);
        return (T)MqlExpression.newMqlExpression(cr -> this.astDoc("$getField", new BsonDocument().append("input", this.fn.apply((CodecRegistry)cr).bsonValue).append("field", MqlExpression.toBsonValue(cr, key))));
    }

    @Override
    public T get(MqlString key, T other) {
        Assertions.notNull("key", key);
        Assertions.notNull("other", other);
        MqlExpression mqlExpression = (MqlExpression)this.get(key);
        return (T)mqlExpression.eq((MqlValue)MqlExpression.ofRem()).cond(other, mqlExpression);
    }

    @Override
    public MqlMap<T> set(MqlString key, T value) {
        Assertions.notNull("key", key);
        Assertions.notNull("value", value);
        return (MqlMap)MqlExpression.newMqlExpression(cr -> this.astDoc("$setField", new BsonDocument().append("field", MqlExpression.toBsonValue(cr, key)).append("input", this.toBsonValue((CodecRegistry)cr)).append("value", MqlExpression.toBsonValue(cr, value))));
    }

    @Override
    public MqlMap<T> unset(MqlString key) {
        Assertions.notNull("key", key);
        return (MqlMap)MqlExpression.newMqlExpression(cr -> this.astDoc("$unsetField", new BsonDocument().append("field", MqlExpression.toBsonValue(cr, key)).append("input", this.toBsonValue((CodecRegistry)cr))));
    }

    @Override
    public MqlMap<T> merge(MqlMap<? extends T> other) {
        Assertions.notNull("other", other);
        return new MqlExpression<T>(this.ast("$mergeObjects", other));
    }

    @Override
    public MqlArray<MqlEntry<T>> entries() {
        return (MqlArray)MqlExpression.newMqlExpression(this.ast("$objectToArray"));
    }

    @Override
    public <R extends MqlValue> MqlMap<R> asMap(Function<? super T, ? extends MqlEntry<? extends R>> mapper) {
        Assertions.notNull("mapper", mapper);
        MqlExpression array = (MqlExpression)this.map(mapper);
        return (MqlMap)MqlExpression.newMqlExpression(array.astWrapped("$arrayToObject"));
    }

    public <Q extends MqlValue> MqlMap<Q> asMap() {
        return this;
    }

    @Override
    public <R extends MqlDocument> R asDocument() {
        return (R)this;
    }

    static final class AstPlaceholder {
        private final BsonValue bsonValue;

        AstPlaceholder(BsonValue bsonValue) {
            this.bsonValue = bsonValue;
        }
    }
}

