/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.model.geojson;

import java.io.StringWriter;
import java.util.Objects;
import net.zaiyers.Channels.lib.bson.codecs.Codec;
import net.zaiyers.Channels.lib.bson.codecs.EncoderContext;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistries;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.Channels.lib.bson.json.JsonWriter;
import net.zaiyers.Channels.lib.bson.json.JsonWriterSettings;
import net.zaiyers.Channels.lib.mongodb.client.model.geojson.CoordinateReferenceSystem;
import net.zaiyers.Channels.lib.mongodb.client.model.geojson.GeoJsonObjectType;
import net.zaiyers.Channels.lib.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public abstract class Geometry {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new GeoJsonCodecProvider());
    private final CoordinateReferenceSystem coordinateReferenceSystem;

    protected Geometry() {
        this(null);
    }

    protected Geometry(@Nullable CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    public abstract GeoJsonObjectType getType();

    public String toJson() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter, JsonWriterSettings.builder().build());
        Codec<?> codec = Geometry.getRegistry().get(this.getClass());
        codec.encode(writer, this, EncoderContext.builder().build());
        return stringWriter.toString();
    }

    static CodecRegistry getRegistry() {
        return REGISTRY;
    }

    @Nullable
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Geometry geometry = (Geometry)o;
        return Objects.equals(this.coordinateReferenceSystem, geometry.coordinateReferenceSystem);
    }

    public int hashCode() {
        return this.coordinateReferenceSystem != null ? this.coordinateReferenceSystem.hashCode() : 0;
    }
}

