/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Supplier;
import net.zaiyers.Channels.lib.bson.BsonBinary;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonValue;
import net.zaiyers.Channels.lib.bson.RawBsonDocument;
import net.zaiyers.Channels.lib.mongodb.MongoClientException;
import net.zaiyers.Channels.lib.mongodb.MongoException;
import net.zaiyers.Channels.lib.mongodb.MongoInternalException;
import net.zaiyers.Channels.lib.mongodb.annotations.Beta;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.MongoClient;
import net.zaiyers.Channels.lib.mongodb.client.internal.CollectionInfoRetriever;
import net.zaiyers.Channels.lib.mongodb.client.internal.CommandMarker;
import net.zaiyers.Channels.lib.mongodb.client.internal.KeyManagementService;
import net.zaiyers.Channels.lib.mongodb.client.internal.KeyRetriever;
import net.zaiyers.Channels.lib.mongodb.client.model.vault.DataKeyOptions;
import net.zaiyers.Channels.lib.mongodb.client.model.vault.EncryptOptions;
import net.zaiyers.Channels.lib.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import net.zaiyers.Channels.lib.mongodb.crypt.capi.MongoCrypt;
import net.zaiyers.Channels.lib.mongodb.crypt.capi.MongoCryptContext;
import net.zaiyers.Channels.lib.mongodb.crypt.capi.MongoCryptException;
import net.zaiyers.Channels.lib.mongodb.crypt.capi.MongoDataKeyOptions;
import net.zaiyers.Channels.lib.mongodb.crypt.capi.MongoKeyDecryptor;
import net.zaiyers.Channels.lib.mongodb.crypt.capi.MongoRewrapManyDataKeyOptions;
import net.zaiyers.Channels.lib.mongodb.internal.capi.MongoCryptHelper;
import net.zaiyers.Channels.lib.mongodb.internal.client.vault.EncryptOptionsHelper;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public class Crypt
implements Closeable {
    private static final RawBsonDocument EMPTY_RAW_BSON_DOCUMENT = RawBsonDocument.parse("{}");
    private final MongoCrypt mongoCrypt;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;
    private final MongoClient internalClient;

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
        this(mongoCrypt, keyRetriever, keyManagementService, kmsProviders, kmsProviderPropertySuppliers, false, null, null, null);
    }

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers, boolean bypassAutoEncryption, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, @Nullable MongoClient internalClient) {
        this.mongoCrypt = mongoCrypt;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.kmsProviders = kmsProviders;
        this.kmsProviderPropertySuppliers = kmsProviderPropertySuppliers;
        this.bypassAutoEncryption = bypassAutoEncryption;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.internalClient = internalClient;
    }

    RawBsonDocument encrypt(String databaseName, RawBsonDocument command) {
        RawBsonDocument rawBsonDocument;
        block9: {
            Assertions.notNull("databaseName", databaseName);
            Assertions.notNull("command", command);
            if (this.bypassAutoEncryption) {
                return command;
            }
            MongoCryptContext encryptionContext = this.mongoCrypt.createEncryptionContext(databaseName, (BsonDocument)command);
            try {
                rawBsonDocument = this.executeStateMachine(encryptionContext, databaseName);
                if (encryptionContext == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (encryptionContext != null) {
                        try {
                            encryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInClientException(e);
                }
            }
            encryptionContext.close();
        }
        return rawBsonDocument;
    }

    RawBsonDocument decrypt(RawBsonDocument commandResponse) {
        RawBsonDocument rawBsonDocument;
        block8: {
            Assertions.notNull("commandResponse", commandResponse);
            MongoCryptContext decryptionContext = this.mongoCrypt.createDecryptionContext((BsonDocument)commandResponse);
            try {
                rawBsonDocument = this.executeStateMachine(decryptionContext, null);
                if (decryptionContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (decryptionContext != null) {
                        try {
                            decryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInClientException(e);
                }
            }
            decryptionContext.close();
        }
        return rawBsonDocument;
    }

    BsonDocument createDataKey(String kmsProvider, DataKeyOptions options) {
        RawBsonDocument rawBsonDocument;
        block8: {
            Assertions.notNull("kmsProvider", kmsProvider);
            Assertions.notNull("options", options);
            MongoCryptContext dataKeyCreationContext = this.mongoCrypt.createDataKeyContext(kmsProvider, MongoDataKeyOptions.builder().keyAltNames(options.getKeyAltNames()).masterKey(options.getMasterKey()).keyMaterial(options.getKeyMaterial()).build());
            try {
                rawBsonDocument = this.executeStateMachine(dataKeyCreationContext, null);
                if (dataKeyCreationContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataKeyCreationContext != null) {
                        try {
                            dataKeyCreationContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInClientException(e);
                }
            }
            dataKeyCreationContext.close();
        }
        return rawBsonDocument;
    }

    BsonBinary encryptExplicitly(BsonValue value, EncryptOptions options) {
        BsonBinary bsonBinary;
        block8: {
            Assertions.notNull("value", value);
            Assertions.notNull("options", options);
            MongoCryptContext encryptionContext = this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", value), EncryptOptionsHelper.asMongoExplicitEncryptOptions(options));
            try {
                bsonBinary = this.executeStateMachine(encryptionContext, null).getBinary("v");
                if (encryptionContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (encryptionContext != null) {
                        try {
                            encryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInClientException(e);
                }
            }
            encryptionContext.close();
        }
        return bsonBinary;
    }

    @Beta(value={Beta.Reason.SERVER})
    BsonDocument encryptExpression(BsonDocument expression, EncryptOptions options) {
        BsonDocument bsonDocument;
        block8: {
            Assertions.notNull("expression", expression);
            Assertions.notNull("options", options);
            MongoCryptContext encryptionContext = this.mongoCrypt.createEncryptExpressionContext(new BsonDocument("v", expression), EncryptOptionsHelper.asMongoExplicitEncryptOptions(options));
            try {
                bsonDocument = this.executeStateMachine(encryptionContext, null).getDocument("v");
                if (encryptionContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (encryptionContext != null) {
                        try {
                            encryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInClientException(e);
                }
            }
            encryptionContext.close();
        }
        return bsonDocument;
    }

    BsonValue decryptExplicitly(BsonBinary value) {
        BsonValue bsonValue;
        block8: {
            Assertions.notNull("value", value);
            MongoCryptContext decryptionContext = this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", value));
            try {
                bsonValue = Assertions.assertNotNull(this.executeStateMachine(decryptionContext, null).get("v"));
                if (decryptionContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (decryptionContext != null) {
                        try {
                            decryptionContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInClientException(e);
                }
            }
            decryptionContext.close();
        }
        return bsonValue;
    }

    BsonDocument rewrapManyDataKey(BsonDocument filter, RewrapManyDataKeyOptions options) {
        RawBsonDocument rawBsonDocument;
        block8: {
            Assertions.notNull("filter", filter);
            MongoCryptContext rewrapManyDatakeyContext = this.mongoCrypt.createRewrapManyDatakeyContext(filter, MongoRewrapManyDataKeyOptions.builder().provider(options.getProvider()).masterKey(options.getMasterKey()).build());
            try {
                rawBsonDocument = this.executeStateMachine(rewrapManyDatakeyContext, null);
                if (rewrapManyDatakeyContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rewrapManyDatakeyContext != null) {
                        try {
                            rewrapManyDatakeyContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoCryptException e) {
                    throw this.wrapInClientException(e);
                }
            }
            rewrapManyDatakeyContext.close();
        }
        return rawBsonDocument;
    }

    @Override
    public void close() {
        try (MongoCrypt ignored = this.mongoCrypt;
             CommandMarker ignored1 = this.commandMarker;){
            MongoClient ignored2 = this.internalClient;
            if (ignored2 != null) {
                ignored2.close();
            }
        }
    }

    private RawBsonDocument executeStateMachine(MongoCryptContext cryptContext, @Nullable String databaseName) {
        MongoCryptContext.State state;
        block9: while (true) {
            state = cryptContext.getState();
            switch (state) {
                case NEED_MONGO_COLLINFO: {
                    this.collInfo(cryptContext, Assertions.notNull("databaseName", databaseName));
                    continue block9;
                }
                case NEED_MONGO_MARKINGS: {
                    this.mark(cryptContext, Assertions.notNull("databaseName", databaseName));
                    continue block9;
                }
                case NEED_KMS_CREDENTIALS: {
                    this.fetchCredentials(cryptContext);
                    continue block9;
                }
                case NEED_MONGO_KEYS: {
                    this.fetchKeys(cryptContext);
                    continue block9;
                }
                case NEED_KMS: {
                    this.decryptKeys(cryptContext);
                    continue block9;
                }
                case READY: {
                    return cryptContext.finish();
                }
                case DONE: {
                    return EMPTY_RAW_BSON_DOCUMENT;
                }
            }
            break;
        }
        throw new MongoInternalException("Unsupported encryptor state + " + state);
    }

    private void fetchCredentials(MongoCryptContext cryptContext) {
        cryptContext.provideKmsProviderCredentials(MongoCryptHelper.fetchCredentials(this.kmsProviders, this.kmsProviderPropertySuppliers));
    }

    private void collInfo(MongoCryptContext cryptContext, String databaseName) {
        try {
            BsonDocument collectionInfo = Assertions.assertNotNull(this.collectionInfoRetriever).filter(databaseName, cryptContext.getMongoOperation());
            if (collectionInfo != null) {
                cryptContext.addMongoOperationResult(collectionInfo);
            }
            cryptContext.completeMongoOperation();
        }
        catch (Throwable t) {
            throw MongoException.fromThrowableNonNull(t);
        }
    }

    private void mark(MongoCryptContext cryptContext, String databaseName) {
        try {
            RawBsonDocument markedCommand = Assertions.assertNotNull(this.commandMarker).mark(databaseName, cryptContext.getMongoOperation());
            cryptContext.addMongoOperationResult((BsonDocument)markedCommand);
            cryptContext.completeMongoOperation();
        }
        catch (Throwable t) {
            throw this.wrapInClientException(t);
        }
    }

    private void fetchKeys(MongoCryptContext keyBroker) {
        try {
            for (BsonDocument bsonDocument : this.keyRetriever.find(keyBroker.getMongoOperation())) {
                keyBroker.addMongoOperationResult(bsonDocument);
            }
            keyBroker.completeMongoOperation();
        }
        catch (Throwable t) {
            throw MongoException.fromThrowableNonNull(t);
        }
    }

    private void decryptKeys(MongoCryptContext cryptContext) {
        try {
            MongoKeyDecryptor keyDecryptor = cryptContext.nextKeyDecryptor();
            while (keyDecryptor != null) {
                this.decryptKey(keyDecryptor);
                keyDecryptor = cryptContext.nextKeyDecryptor();
            }
            cryptContext.completeKeyDecryptors();
        }
        catch (Throwable t) {
            throw this.wrapInClientException(t);
        }
    }

    private void decryptKey(MongoKeyDecryptor keyDecryptor) throws IOException {
        try (InputStream inputStream = this.keyManagementService.stream(keyDecryptor.getKmsProvider(), keyDecryptor.getHostName(), keyDecryptor.getMessage());){
            int bytesNeeded = keyDecryptor.bytesNeeded();
            while (bytesNeeded > 0) {
                byte[] bytes = new byte[bytesNeeded];
                int bytesRead = inputStream.read(bytes, 0, bytes.length);
                keyDecryptor.feed(ByteBuffer.wrap(bytes, 0, bytesRead));
                bytesNeeded = keyDecryptor.bytesNeeded();
            }
        }
    }

    private MongoClientException wrapInClientException(Throwable t) {
        return new MongoClientException("Exception in encryption library: " + t.getMessage(), t);
    }
}

