/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.gridfs.codecs;

import java.util.Date;
import net.zaiyers.Channels.lib.bson.BsonDateTime;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonDocumentReader;
import net.zaiyers.Channels.lib.bson.BsonDocumentWrapper;
import net.zaiyers.Channels.lib.bson.BsonInt32;
import net.zaiyers.Channels.lib.bson.BsonInt64;
import net.zaiyers.Channels.lib.bson.BsonReader;
import net.zaiyers.Channels.lib.bson.BsonString;
import net.zaiyers.Channels.lib.bson.BsonValue;
import net.zaiyers.Channels.lib.bson.BsonWriter;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.bson.codecs.Codec;
import net.zaiyers.Channels.lib.bson.codecs.DecoderContext;
import net.zaiyers.Channels.lib.bson.codecs.EncoderContext;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.gridfs.model.GridFSFile;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public final class GridFSFileCodec
implements Codec<GridFSFile> {
    private final Codec<Document> documentCodec;
    private final Codec<BsonDocument> bsonDocumentCodec;

    public GridFSFileCodec(CodecRegistry registry) {
        this.documentCodec = Assertions.notNull("DocumentCodec", Assertions.notNull("registry", registry).get(Document.class));
        this.bsonDocumentCodec = Assertions.notNull("BsonDocumentCodec", registry.get(BsonDocument.class));
    }

    @Override
    public GridFSFile decode(BsonReader reader, DecoderContext decoderContext) {
        BsonDocument bsonDocument = (BsonDocument)this.bsonDocumentCodec.decode(reader, decoderContext);
        BsonValue id = bsonDocument.get("_id");
        String filename = bsonDocument.get("filename", new BsonString("")).asString().getValue();
        long length = bsonDocument.getNumber("length").longValue();
        int chunkSize = bsonDocument.getNumber("chunkSize").intValue();
        Date uploadDate = new Date(bsonDocument.getDateTime("uploadDate").getValue());
        BsonDocument metadataBsonDocument = bsonDocument.getDocument("metadata", new BsonDocument());
        Document optionalMetadata = this.asDocumentOrNull(metadataBsonDocument);
        return new GridFSFile(id, filename, length, chunkSize, uploadDate, optionalMetadata);
    }

    @Override
    public void encode(BsonWriter writer, GridFSFile value, EncoderContext encoderContext) {
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("_id", value.getId());
        bsonDocument.put("filename", new BsonString(value.getFilename()));
        bsonDocument.put("length", new BsonInt64(value.getLength()));
        bsonDocument.put("chunkSize", new BsonInt32(value.getChunkSize()));
        bsonDocument.put("uploadDate", new BsonDateTime(value.getUploadDate().getTime()));
        Document metadata = value.getMetadata();
        if (metadata != null) {
            bsonDocument.put("metadata", new BsonDocumentWrapper<Document>(metadata, this.documentCodec));
        }
        this.bsonDocumentCodec.encode(writer, bsonDocument, encoderContext);
    }

    @Override
    public Class<GridFSFile> getEncoderClass() {
        return GridFSFile.class;
    }

    @Nullable
    private Document asDocumentOrNull(BsonDocument bsonDocument) {
        if (bsonDocument.isEmpty()) {
            return null;
        }
        BsonDocumentReader reader = new BsonDocumentReader(bsonDocument);
        return (Document)this.documentCodec.decode(reader, DecoderContext.builder().build());
    }
}

