/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.bson.internal;

import java.lang.reflect.Type;
import java.util.List;
import net.zaiyers.Channels.lib.bson.BsonReader;
import net.zaiyers.Channels.lib.bson.BsonWriter;
import net.zaiyers.Channels.lib.bson.codecs.Codec;
import net.zaiyers.Channels.lib.bson.codecs.DecoderContext;
import net.zaiyers.Channels.lib.bson.codecs.EncoderContext;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;

class LazyCodec<T>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> clazz;
    private final List<Type> types;
    private volatile Codec<T> wrapped;

    LazyCodec(CodecRegistry registry, Class<T> clazz, List<Type> types) {
        this.registry = registry;
        this.clazz = clazz;
        this.types = types;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.getWrapped().encode(writer, value, encoderContext);
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return this.getWrapped().decode(reader, decoderContext);
    }

    private Codec<T> getWrapped() {
        if (this.wrapped == null) {
            this.wrapped = this.types == null ? this.registry.get(this.clazz) : this.registry.get(this.clazz, this.types);
        }
        return this.wrapped;
    }
}

