/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.bson.codecs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.zaiyers.Channels.lib.bson.BsonReader;
import net.zaiyers.Channels.lib.bson.BsonType;
import net.zaiyers.Channels.lib.bson.BsonWriter;
import net.zaiyers.Channels.lib.bson.assertions.Assertions;
import net.zaiyers.Channels.lib.bson.codecs.Codec;
import net.zaiyers.Channels.lib.bson.codecs.DecoderContext;
import net.zaiyers.Channels.lib.bson.codecs.EncoderContext;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecConfigurationException;

abstract class AbstractCollectionCodec<T, C extends Collection<T>>
implements Codec<C> {
    private final Class<C> clazz;
    private final Supplier<C> supplier;

    AbstractCollectionCodec(Class<C> clazz) {
        this.clazz = Assertions.notNull("clazz", clazz);
        Class rawClass = clazz;
        if (rawClass == Collection.class || rawClass == List.class || rawClass == AbstractCollection.class || rawClass == AbstractList.class || rawClass == ArrayList.class) {
            this.supplier = () -> new ArrayList();
        } else if (rawClass == Set.class || rawClass == AbstractSet.class || rawClass == HashSet.class) {
            this.supplier = () -> new HashSet();
        } else if (rawClass == NavigableSet.class || rawClass == SortedSet.class || rawClass == TreeSet.class) {
            this.supplier = () -> new TreeSet();
        } else {
            Supplier<Collection> supplier;
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                supplier = () -> {
                    try {
                        return (Collection)constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new CodecConfigurationException(String.format("Can not invoke no-args constructor for Collection class %s", clazz), e);
                    }
                };
            }
            catch (NoSuchMethodException e) {
                supplier = () -> {
                    throw new CodecConfigurationException(String.format("No no-args constructor for Collection class %s", clazz), e);
                };
            }
            this.supplier = supplier;
        }
    }

    abstract T readValue(BsonReader var1, DecoderContext var2);

    abstract void writeValue(BsonWriter var1, T var2, EncoderContext var3);

    @Override
    public C decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        Collection collection = (Collection)this.supplier.get();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                collection.add(null);
                continue;
            }
            collection.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return (C)collection;
    }

    @Override
    public void encode(BsonWriter writer, C value, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (Object cur : value) {
            if (cur == null) {
                writer.writeNull();
                continue;
            }
            this.writeValue(writer, cur, encoderContext);
        }
        writer.writeEndArray();
    }

    @Override
    public Class<C> getEncoderClass() {
        return this.clazz;
    }
}

