/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.Config;

public abstract class YamlConfig
implements Config {
    protected Configuration cfg;
    private final Configuration defaultCfg;
    protected static final ConfigurationProvider ymlCfg = ConfigurationProvider.getProvider(YamlConfiguration.class);
    protected File configFile;

    public YamlConfig(File configFile) throws IOException {
        this.configFile = configFile;
        InputStream stream = Channels.getInstance().getResourceAsStream(configFile.getName());
        this.defaultCfg = stream != null ? ymlCfg.load((Reader)new InputStreamReader(stream)) : null;
        this.load();
    }

    public void load() throws IOException {
        if (!this.configFile.exists()) {
            if (!this.configFile.getParentFile().exists()) {
                this.configFile.getParentFile().mkdirs();
            }
            this.configFile.createNewFile();
            this.cfg = ymlCfg.load(this.configFile, this.defaultCfg);
            this.createDefaultConfig();
        } else {
            this.cfg = ymlCfg.load(this.configFile, this.defaultCfg);
        }
    }

    @Override
    public void save() {
        try {
            ymlCfg.save(this.cfg, this.configFile);
        }
        catch (IOException e) {
            Channels.getInstance().getLogger().severe("Unable to save configuration at " + this.configFile.getAbsolutePath());
            e.printStackTrace();
        }
    }

    @Override
    public void removeConfig() {
        this.configFile.delete();
    }
}

