/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.ChatterConfig;
import net.zaiyers.Channels.config.MongoConfig;
import net.zaiyers.Channels.config.MongoConfiguration;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.mongodb.client.MongoCollection;

public class ChatterMongoConfig
extends MongoConfig
implements ChatterConfig {
    public ChatterMongoConfig(MongoCollection<Document> c, String string) {
        super(c, string);
    }

    @Override
    public List<String> getSubscriptions() {
        return this.cfg.getStringList("subscriptions");
    }

    @Override
    public boolean isMuted() {
        return this.cfg.getBoolean("muted", false);
    }

    @Override
    public List<String> getIgnores() {
        return this.cfg.getStringList("ignores");
    }

    @Override
    public String getPrefix() {
        return this.cfg.getString("prefix", "");
    }

    @Override
    public String getSuffix() {
        return this.cfg.getString("suffix", "");
    }

    @Override
    public String getLastSender() {
        return this.cfg.getString("lastSender", null);
    }

    @Override
    public String getChannelUUID() {
        return this.cfg.getString("channelUUID");
    }

    @Override
    public void createDefaultConfig() {
        this.cfg = new MongoConfiguration(Channels.getConfig().getMongoDBConnection().getChatters(), null);
        this.cfg.load(new InputStreamReader(Channels.getInstance().getResourceAsStream("chatter.yml")));
        this.cfg.set("uuid", this.uuid.toString());
        this.cfg.set("channelUUID", Channels.getConfig().getDefaultChannelUUID().toString());
        ArrayList<String> subs = new ArrayList<String>();
        subs.add(Channels.getConfig().getDefaultChannelUUID());
        this.setSubscriptions(subs);
        this.save();
    }

    @Override
    public void setSubscriptions(List<String> subs) {
        ArrayList<String> subscriptions = new ArrayList<String>();
        for (String u : subs) {
            subscriptions.add(u.toString());
        }
        this.cfg.set("subscriptions", subscriptions);
    }

    @Override
    public void setMuted(boolean b) {
        this.cfg.set("muted", b);
    }

    @Override
    public void setPrefix(String prefix) {
        this.cfg.set("prefix", prefix);
    }

    @Override
    public void setSuffix(String suffix) {
        this.cfg.set("prefix", suffix);
    }

    @Override
    public void removeIgnore(String ignoreUUID) {
        List<String> ignores = this.cfg.getStringList("ignores");
        ignores.remove(ignoreUUID);
        this.cfg.set("ignores", ignores);
    }

    @Override
    public void addIgnore(String uuid) {
        List<String> ignores = this.cfg.getStringList("ignores");
        ignores.add(uuid);
        this.cfg.set("ignores", ignores);
    }

    @Override
    public void setDefaultChannel(String uuid) {
        this.cfg.set("channelUUID", uuid);
    }

    @Override
    public void setLastSender(String uuid) {
        this.cfg.set("lastSender", uuid);
    }
}

