/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.ChannelConfig;
import net.zaiyers.Channels.config.YamlConfig;

public class ChannelYamlConfig
extends YamlConfig
implements ChannelConfig {
    public ChannelYamlConfig(File configFile) throws IOException {
        super(configFile);
    }

    @Override
    public String getName() {
        return this.cfg.getString("name");
    }

    @Override
    public String getTag() {
        return this.cfg.getString("tag");
    }

    @Override
    public String getFormat() {
        return this.cfg.getString("format");
    }

    @Override
    public ChatColor getColor() {
        return ChatColor.of((String)this.cfg.getString("color"));
    }

    @Override
    public String getPassword() {
        return this.cfg.getString("password", "");
    }

    @Override
    public List<String> getServers() {
        return this.cfg.getStringList("servers");
    }

    @Override
    public List<String> getModerators() {
        return this.cfg.getStringList("moderators");
    }

    @Override
    public List<String> getBans() {
        return this.cfg.getStringList("bans");
    }

    @Override
    public void setName(String name) {
        this.cfg.set("name", (Object)name);
    }

    @Override
    public void setTag(String tag) {
        this.cfg.set("tag", (Object)tag);
    }

    @Override
    public void setFormat(String format) {
        this.cfg.set("format", (Object)format);
    }

    @Override
    public void setPassword(String password) {
        if (password == null) {
            this.cfg.set("password", (Object)"");
        } else {
            this.cfg.set("password", (Object)password);
        }
    }

    @Override
    public String getUUID() {
        return this.configFile.getName().substring(0, 36);
    }

    @Override
    public void createDefaultConfig() {
        this.cfg = ymlCfg.load((Reader)new InputStreamReader(Channels.getInstance().getResourceAsStream("channel.yml")));
        this.save();
    }

    @Override
    public void addServer(String servername) {
        List<String> servers = this.getServers();
        servers.add(servername);
        this.cfg.set("servers", servers);
    }

    @Override
    public void removeServer(String servername) {
        List<String> servers = this.getServers();
        servers.remove(servername);
        this.cfg.set("servers", servers);
    }

    @Override
    public void addModerator(String uuid) {
        List<String> moderators = this.getModerators();
        moderators.add(uuid);
        this.cfg.set("moderators", moderators);
    }

    @Override
    public void removeModerator(String modUUID) {
        List<String> moderators = this.getModerators();
        moderators.remove(modUUID);
        this.cfg.set("moderators", moderators);
    }

    @Override
    public void setAutojoin(boolean b) {
        this.cfg.set("autojoin", (Object)b);
    }

    @Override
    public boolean doAutojoin() {
        return this.cfg.getBoolean("autojoin", false);
    }

    @Override
    public void addBan(String chatterUUID) {
        List<String> bans = this.getBans();
        bans.add(chatterUUID);
        this.cfg.set("bans", bans);
    }

    @Override
    public void removeBan(String chatterUUID) {
        List<String> bans = this.getBans();
        bans.remove(chatterUUID);
        this.cfg.set("bans", bans);
    }

    @Override
    public void setColor(ChatColor color) {
        this.cfg.set("color", (Object)color.name());
    }

    @Override
    public void setGlobal(boolean global) {
        this.cfg.set("global", (Object)global);
    }

    @Override
    public boolean isGlobal() {
        return this.cfg.getBoolean("global");
    }

    @Override
    public void setBackend(boolean backend) {
        this.cfg.set("backend", (Object)backend);
    }

    @Override
    public boolean isBackend() {
        return this.cfg.getBoolean("backend");
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        this.cfg.set("autofocus", (Object)autofocus);
    }

    @Override
    public boolean doAutofocus() {
        return this.cfg.getBoolean("autofocus", false);
    }
}

