/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.ChannelsCommandExecutor;
import net.zaiyers.Channels.events.ChannelsChatEvent;
import net.zaiyers.Channels.message.AbstractMessage;
import net.zaiyers.Channels.message.ChannelMessage;
import net.zaiyers.Channels.message.ConsoleMessage;

public class ChannelTagCommandExecutor
extends Command
implements TabExecutor {
    private String channelUUID;

    public ChannelTagCommandExecutor(String name) {
        super(name);
        this.channelUUID = Channels.getInstance().getChannel(name).getUUID();
    }

    public void execute(CommandSender sender, String[] args) {
        AbstractMessage msg;
        Channel chan = Channels.getInstance().getChannel(this.channelUUID);
        if (!(sender instanceof ProxiedPlayer)) {
            msg = new ConsoleMessage(chan, this.argsToMessage(args));
        } else {
            Chatter chatter = Channels.getInstance().getChatter(((ProxiedPlayer)sender).getUniqueId());
            if (!chatter.getSubscriptions().contains(chan.getUUID())) {
                Channels.notify(sender, "channels.chatter.channel-not-subscribed", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                return;
            }
            if (!chatter.hasPermission(chan, "speak")) {
                Channels.notify(sender, "channels.permission.channel-no-speak", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                return;
            }
            if (args.length == 0) {
                chatter.setDefaultChannelUUID(chan.getUUID());
                chatter.setPrivateRecipient(null);
                Channels.notify(sender, "channels.chatter.default-channel-set", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                return;
            }
            if (chan.isBackend()) {
                ((ProxiedPlayer)sender).chat(this.argsToMessage(args));
                return;
            }
            msg = new ChannelMessage(chatter, chan, this.argsToMessage(args));
        }
        ChannelsChatEvent chatEvent = new ChannelsChatEvent(msg);
        if (!((ChannelsChatEvent)Channels.getInstance().getProxy().getPluginManager().callEvent((Event)chatEvent)).isCancelled()) {
            msg.send(chatEvent.isHidden());
        }
    }

    private String argsToMessage(String[] args) {
        Object message = args[0];
        for (int i = 1; i < args.length; ++i) {
            message = (String)message + " " + args[i];
        }
        return message;
    }

    public Iterable<String> onTabComplete(CommandSender arg0, String[] args) {
        return ChannelsCommandExecutor.matchingPlayers(args.length > 0 ? args[args.length - 1] : "");
    }
}

