/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.AbstractCommand;
import net.zaiyers.Channels.events.ChannelsChatEvent;
import net.zaiyers.Channels.message.AbstractMessage;
import net.zaiyers.Channels.message.ChannelMessage;
import net.zaiyers.Channels.message.ConsoleMessage;

public class ChannelSpeakCommand
extends AbstractCommand {
    public ChannelSpeakCommand(CommandSender sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        AbstractMessage msg;
        if (!this.args[1].matches("^[a-zA-Z0-9]+$")) {
            Channels.notify(this.sender, "channels.command.channel-not-found", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.args[1]));
            return;
        }
        Channel chan = Channels.getInstance().getChannel(this.args[1]);
        if (chan == null) {
            Channels.notify(this.sender, "channels.command.channel-not-found", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.args[1]));
            return;
        }
        if (!(this.sender instanceof ProxiedPlayer)) {
            msg = new ConsoleMessage(chan, this.argsToMessage(this.args));
        } else {
            Chatter chatter = Channels.getInstance().getChatter(((ProxiedPlayer)this.sender).getUniqueId());
            if (!chatter.getSubscriptions().contains(chan.getUUID())) {
                Channels.notify(this.sender, "channels.chatter.channel-not-subscribed", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                return;
            }
            if (!chatter.hasPermission(chan, "speak") && !chan.isTemporary()) {
                Channels.notify(this.sender, "channels.permission.channel-no-speak", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                return;
            }
            if (this.args.length == 2) {
                chatter.setDefaultChannelUUID(chan.getUUID());
                chatter.setPrivateRecipient(null);
                Channels.notify(this.sender, "channels.chatter.default-channel-set", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                return;
            }
            if (chan.isBackend()) {
                ((ProxiedPlayer)this.sender).chat(this.argsToMessage(this.args));
                return;
            }
            msg = new ChannelMessage(chatter, chan, this.argsToMessage(this.args));
        }
        ChannelsChatEvent chatEvent = new ChannelsChatEvent(msg);
        if (!((ChannelsChatEvent)Channels.getInstance().getProxy().getPluginManager().callEvent((Event)chatEvent)).isCancelled()) {
            msg.send(chatEvent.isHidden());
        }
    }

    private String argsToMessage(String[] args) {
        Object message = args[2];
        for (int i = 3; i < args.length; ++i) {
            message = (String)message + " " + args[i];
        }
        return message;
    }

    @Override
    public boolean validateInput() {
        return this.args.length > 1;
    }
}

