/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.AbstractCommand;

public class ChannelInfoCommand
extends AbstractCommand {
    public ChannelInfoCommand(CommandSender sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        boolean isConsoleCommand = !(this.sender instanceof ProxiedPlayer);
        Chatter chatter = null;
        if (!isConsoleCommand) {
            chatter = Channels.getInstance().getChatter(((ProxiedPlayer)this.sender).getUniqueId());
        }
        Channel channel = null;
        if (this.args.length == 2) {
            channel = Channels.getInstance().getChannel(this.args[1]);
        } else if (this.args.length == 1 && !isConsoleCommand) {
            channel = Channels.getInstance().getChannel(chatter.getChannel());
        } else {
            Channels.notify(this.sender, "channels.chatter.has-no-channel", new String[0]);
            return;
        }
        if (channel == null) {
            Channels.notify(this.sender, "channels.command.channel-not-found", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.args[1]));
            return;
        }
        if (isConsoleCommand || chatter.hasPermission(channel, "info") || channel.getModerators().contains(chatter.getName())) {
            Channels.notify(this.sender, "channels.command.channel-info-head", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)channel.getName(), (Object)"channelColor", (Object)channel.getColor().toString()));
            Channels.notify(this.sender, "channels.command.channel-info-name", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)channel.getName()));
            Channels.notify(this.sender, "channels.command.channel-info-tag", (Map<String, String>)ImmutableMap.of((Object)"tag", (Object)channel.getTag()));
            if (isConsoleCommand || chatter.hasPermission(channel, "debug")) {
                Channels.notify(this.sender, "channels.command.channel-info-uuid", "uuid", channel.getUUID());
            }
            Channels.notify(this.sender, "channels.command.channel-info-color", (Map<String, String>)ImmutableMap.of((Object)"color", (Object)channel.getColor().toString(), (Object)"colorName", (Object)channel.getColor().name()));
            Channels.notify(this.sender, "channels.command.channel-info-password", (Map<String, String>)ImmutableMap.of((Object)"password", (Object)(channel.getPassword() == null ? "(none)" : channel.getPassword())));
            Channels.notify(this.sender, "channels.command.channel-info-autofocus", (Map<String, String>)ImmutableMap.of((Object)"autofocus", (Object)(channel.doAutofocus() ? "true" : "false")));
            Channels.notify(this.sender, "channels.command.channel-info-autojoin", (Map<String, String>)ImmutableMap.of((Object)"autojoin", (Object)(channel.doAutojoin() ? "true" : "false")));
            Channels.notify(this.sender, "channels.command.channel-info-msgFormat", (Map<String, String>)ImmutableMap.of((Object)"format", (Object)(channel.getFormat() == null ? "(none)" : channel.getFormat())));
            Channels.notify(this.sender, "channels.command.channel-info-global", (Map<String, String>)ImmutableMap.of((Object)"global", (Object)(channel.isGlobal() ? "true" : "false")));
            Channels.notify(this.sender, "channels.command.channel-info-backend", (Map<String, String>)ImmutableMap.of((Object)"backend", (Object)(channel.isBackend() ? "true" : "false")));
            Object servers = "";
            if (channel.getServers().size() > 0) {
                servers = channel.getServers().get(0);
                for (int i = 1; i < channel.getServers().size(); ++i) {
                    servers = (String)servers + ", " + channel.getServers().get(i);
                }
            }
            Channels.notify(this.sender, "channels.command.channel-info-servers", (Map<String, String>)ImmutableMap.of((Object)"servers", (Object)servers));
            Channels.notify(this.sender, "channels.command.channel-info-temp", (Map<String, String>)ImmutableMap.of((Object)"temporary", (Object)(channel.isTemporary() ? "true" : "false")));
            Object moderators = "";
            if (channel.getModerators().size() > 0) {
                moderators = Channels.getPlayerName(channel.getModerators().get(0));
                for (int i = 1; i < channel.getModerators().size(); ++i) {
                    moderators = (String)moderators + ", " + Channels.getPlayerName(channel.getModerators().get(i));
                }
            }
            Channels.notify(this.sender, "channels.command.channel-info-moderators", (Map<String, String>)ImmutableMap.of((Object)"moderators", (Object)moderators));
            Object bans = "";
            if (channel.getBans().size() > 0) {
                bans = Channels.getPlayerName(channel.getBans().get(0));
                for (int i = 1; i < channel.getBans().size(); ++i) {
                    bans = (String)bans + ", " + Channels.getPlayerName(channel.getBans().get(i));
                }
            }
            Channels.notify(this.sender, "channels.command.channel-info-bans", (Map<String, String>)ImmutableMap.of((Object)"bans", (Object)bans));
            Channels.notify(this.sender, "channels.command.channel-info-subscribers", (Map<String, String>)ImmutableMap.of((Object)"subscribers", (Object)("" + channel.getSubscriberUUIDs().size())));
        } else {
            Channels.notify(this.sender, "channels.permission.info-channel", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)channel.getName(), (Object)"channelColor", (Object)channel.getColor().toString()));
        }
    }

    @Override
    public boolean validateInput() {
        return true;
    }
}

