/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import java.io.IOException;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.command.AbstractCommand;
import net.zaiyers.Channels.command.ChannelsCommand;

public class ChannelCreateCommand
extends AbstractCommand
implements ChannelsCommand {
    public ChannelCreateCommand(CommandSender sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        String password = "";
        if (!this.args[1].matches("^[a-zA-Z0-9_]+$")) {
            Channels.notify(this.sender, "channels.usage.channelname-disallowed-chars", new String[0]);
            return;
        }
        String name = this.args[1];
        if (!this.args[2].matches("^[a-zA-Z0-9_]+$")) {
            Channels.notify(this.sender, "channels.usage.channeltag-disallowed-chars", new String[0]);
            return;
        }
        String tag = this.args[2];
        if (this.args.length > 3 && this.args[3].matches("^[a-zA-Z0-9_]+$")) {
            password = this.args[3];
        } else if (this.args.length > 3) {
            Channels.notify(this.sender, "channels.usage.channelpassword-disallowed-chars", new String[0]);
            return;
        }
        if (Channels.getInstance().getChannel(tag) != null) {
            Channels.notify(this.sender, "channels.command.channel-tag-in-use", new String[0]);
            return;
        }
        if (Channels.getInstance().getChannel(name) != null) {
            Channels.notify(this.sender, "channels.command.channel-name-in-use", new String[0]);
            return;
        }
        try {
            String chanUUID = UUID.randomUUID().toString();
            while (Channels.getConfig().getChannels().contains(chanUUID)) {
                chanUUID = UUID.randomUUID().toString();
            }
            Channel chan = new Channel(chanUUID);
            chan.setName(name);
            chan.setTag(tag);
            chan.setPassword(password);
            chan.save();
            Channels.getInstance().addChannel(chan);
            Channels.getInstance().registerTag(tag);
            Channels.notify(this.sender, "channels.command.channel-created", new String[0]);
        }
        catch (IOException e) {
            Channels.getInstance().getLogger().severe("Unable to create new config");
            e.printStackTrace();
        }
    }

    @Override
    public boolean validateInput() {
        return this.args.length > 2;
    }
}

