/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.novucs.ftop.hook.EconomyHook;
import net.novucs.ftop.hook.event.FactionEconomyEvent;
import net.novucs.ftop.hook.event.PlayerEconomyEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.scheduler.BukkitRunnable;

public class VaultEconomyHook
extends BukkitRunnable
implements EconomyHook,
Listener {
    private final Plugin plugin;
    private final Set<String> factionIds;
    private final Map<UUID, Double> playerBalances = new HashMap<UUID, Double>();
    private final Map<String, Double> factionBalances = new HashMap<String, Double>();
    private boolean enabled;
    private boolean playerEnabled;
    private boolean factionEnabled;
    private int liquidUpdateTicks;
    private Economy economy;

    public VaultEconomyHook(Plugin plugin, Set<String> factionIds) {
        this.plugin = plugin;
        this.factionIds = factionIds;
    }

    public void setLiquidUpdateTicks(int liquidUpdateTicks) {
        this.liquidUpdateTicks = liquidUpdateTicks;
    }

    public void initialize() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null || (this.economy = (Economy)rsp.getProvider()) == null) {
            this.plugin.getLogger().warning("No economy provider for Vault found!");
            this.plugin.getLogger().warning("Economy support by Vault is now disabled.");
            return;
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.runTaskTimer(this.plugin, this.liquidUpdateTicks, this.liquidUpdateTicks);
        this.enabled = true;
    }

    public void terminate() {
        if (this.enabled) {
            HandlerList.unregisterAll((Listener)this);
            this.cancel();
            this.enabled = false;
        }
    }

    public void setPlayerEnabled(boolean enabled) {
        this.playerEnabled = enabled;
    }

    public void setFactionEnabled(boolean enabled) {
        this.factionEnabled = enabled;
    }

    public double getBalance(Player player) {
        return this.economy == null ? 0.0 : this.economy.getBalance((OfflinePlayer)player);
    }

    public double getBalance(UUID playerId) {
        return this.economy == null ? 0.0 : this.economy.getBalance(this.plugin.getServer().getOfflinePlayer(playerId));
    }

    public double getTotalBalance(List<UUID> playerIds) {
        double balance = 0.0;
        for (UUID playerId : playerIds) {
            balance += this.economy.getBalance(this.plugin.getServer().getOfflinePlayer(playerId));
        }
        return balance;
    }

    public double getFactionBalance(String factionId) {
        return this.economy == null ? 0.0 : this.economy.getBalance(factionId);
    }

    public void run() {
        if (this.playerEnabled) {
            this.tickPlayers();
        }
        if (this.factionEnabled) {
            this.tickFactions();
        }
    }

    private void tickPlayers() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            UUID playerId = player.getUniqueId();
            Double oldBalance = this.playerBalances.get(playerId);
            Double newBalance = this.economy.getBalance((OfflinePlayer)player);
            if (oldBalance == null) {
                this.playerBalances.put(playerId, newBalance);
                continue;
            }
            if (oldBalance.doubleValue() == newBalance.doubleValue()) continue;
            this.playerBalances.put(playerId, newBalance);
            this.callEvent((Event)new PlayerEconomyEvent(player, oldBalance.doubleValue(), newBalance.doubleValue()));
        }
    }

    private void tickFactions() {
        for (String factionId : this.factionIds) {
            Double oldBalance = this.factionBalances.getOrDefault(factionId, 0.0);
            Double newBalance = this.economy.getBalance("faction-" + factionId);
            if (oldBalance == null) {
                this.factionBalances.put(factionId, newBalance);
                continue;
            }
            if (oldBalance.doubleValue() == newBalance.doubleValue()) continue;
            this.factionBalances.put(factionId, newBalance);
            this.callEvent((Event)new FactionEconomyEvent(factionId, oldBalance.doubleValue(), newBalance.doubleValue()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void addPlayer(PlayerJoinEvent event) {
        this.playerBalances.put(event.getPlayer().getUniqueId(), this.economy.getBalance((OfflinePlayer)event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void clearPlayerData(PlayerQuitEvent event) {
        this.playerBalances.remove(event.getPlayer().getUniqueId());
    }

    private void callEvent(Event event) {
        this.plugin.getServer().getPluginManager().callEvent(event);
    }
}

