/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.entity.ChunkPos;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class FactionsHook
implements Listener,
PluginService {
    private final Plugin plugin;

    public FactionsHook(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void initialize() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @Override
    public void terminate() {
        HandlerList.unregisterAll((Listener)this);
    }

    public String getFactionAt(ChunkPos pos) {
        return this.getFactionAt(pos.getWorld(), pos.getX(), pos.getZ());
    }

    public String getFactionAt(Block block) {
        return this.getFactionAt(block.getWorld().getName(), block.getChunk().getX(), block.getChunk().getZ());
    }

    public abstract String getFactionAt(String var1, int var2, int var3);

    public abstract String getFaction(Player var1);

    public abstract String getFactionName(String var1);

    public abstract boolean isFaction(String var1);

    public abstract ChatColor getRelation(Player var1, String var2);

    public abstract String getOwnerName(String var1);

    public abstract List<UUID> getMembers(String var1);

    public abstract List<ChunkPos> getClaims();

    public abstract Set<String> getFactionIds();

    void callEvent(Event event) {
        if (this.plugin.getServer().isPrimaryThread()) {
            this.plugin.getServer().getPluginManager().callEvent(event);
            return;
        }
        this.plugin.getServer().getScheduler().runTask(this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent(event));
    }
}

