/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.entity;

import java.util.Objects;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Server;

public class ChunkPos {
    private final String world;
    private final int x;
    private final int z;

    public static ChunkPos of(Chunk chunk) {
        return new ChunkPos(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
    }

    public static ChunkPos of(ChunkSnapshot snapshot) {
        return new ChunkPos(snapshot.getWorldName(), snapshot.getX(), snapshot.getZ());
    }

    public static ChunkPos of(String world, int x, int z) {
        return new ChunkPos(world, x, z);
    }

    private ChunkPos(String world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Chunk getChunk(Server server) {
        if (server.getWorld(this.world) == null) {
            return null;
        }
        return server.getWorld(this.world).getChunkAt(this.x, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkPos chunkPos = (ChunkPos)o;
        return this.x == chunkPos.x && this.z == chunkPos.z && Objects.equals(this.world, chunkPos.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.z);
    }

    public String toString() {
        return "ChunkPos{world='" + this.world + '\'' + ", x=" + this.x + ", z=" + this.z + '}';
    }
}

