/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.factions.event.EventFactionsChunksChange;
import com.massivecraft.factions.event.EventFactionsDisband;
import com.massivecraft.factions.event.EventFactionsMembershipChange;
import com.massivecraft.factions.event.EventFactionsNameChange;
import com.massivecraft.massivecore.ps.PS;
import com.massivecraft.massivecore.store.SenderEntity;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.hook.FactionsHook;
import net.novucs.ftop.hook.event.FactionClaimEvent;
import net.novucs.ftop.hook.event.FactionDisbandEvent;
import net.novucs.ftop.hook.event.FactionJoinEvent;
import net.novucs.ftop.hook.event.FactionLeaveEvent;
import net.novucs.ftop.hook.event.FactionRenameEvent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class Factions0211
extends FactionsHook {
    public Factions0211(Plugin plugin) {
        super(plugin);
    }

    public String getFactionAt(String worldName, int chunkX, int chunkZ) {
        Faction faction = BoardColl.get().getFactionAt(PS.valueOf((String)worldName, (int)chunkX, (int)chunkZ));
        return faction == null ? "none" : faction.getId();
    }

    public String getFaction(Player player) {
        return MPlayer.get((Object)player).getFaction().getId();
    }

    public String getFactionName(String factionId) {
        return ((Faction)FactionColl.get().get((Object)factionId)).getName();
    }

    public boolean isFaction(String factionId) {
        return FactionColl.get().get((Object)factionId) != null;
    }

    public ChatColor getRelation(Player player, String factionId) {
        MPlayer mplayer = MPlayer.get((Object)player);
        Faction faction = Faction.get((Object)factionId);
        return mplayer.getFaction().getRelationTo((RelationParticipator)faction).getColor();
    }

    public String getOwnerName(String factionId) {
        MPlayer owner = ((Faction)FactionColl.get().get((Object)factionId)).getLeader();
        return owner == null ? null : owner.getName();
    }

    public List<UUID> getMembers(String factionId) {
        return ((Faction)FactionColl.get().get((Object)factionId)).getMPlayers().stream().map(SenderEntity::getUuid).collect(Collectors.toList());
    }

    public List<ChunkPos> getClaims() {
        LinkedList<ChunkPos> target = new LinkedList<ChunkPos>();
        for (Set ps : BoardColl.get().getFactionToChunks().values()) {
            target.addAll(this.psToChunkPos(ps));
        }
        return target;
    }

    public Set<String> getFactionIds() {
        return new HashSet<String>(FactionColl.get().getIds());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDisband(EventFactionsDisband event) {
        String factionId = event.getFactionId();
        String factionName = event.getFaction().getName();
        this.callEvent((Event)new FactionDisbandEvent(factionId, factionName));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRename(EventFactionsNameChange event) {
        String factionId = event.getFaction().getId();
        String oldName = event.getFaction().getName();
        String newName = event.getNewName();
        this.callEvent((Event)new FactionRenameEvent(factionId, oldName, newName));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(EventFactionsChunksChange event) {
        HashMultimap claims = HashMultimap.create();
        event.getOldFactionChunks().forEach((arg_0, arg_1) -> this.lambda$onClaim$0((Multimap)claims, arg_0, arg_1));
        this.callEvent((Event)new FactionClaimEvent(event.getNewFaction().getId(), (Multimap)claims));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMembershipChange(EventFactionsMembershipChange event) {
        Player player = event.getMPlayer().getPlayer();
        if (player == null) {
            return;
        }
        Faction oldFaction = event.getMPlayer().getFaction();
        Faction newFaction = event.getNewFaction();
        String oldFactionId = event.getMPlayer().getFaction().getId();
        String newFactionId = oldFaction == newFaction ? FactionColl.get().getNone().getId() : newFaction.getId();
        this.callEvent((Event)new FactionLeaveEvent(oldFactionId, player));
        this.callEvent((Event)new FactionJoinEvent(newFactionId, player));
    }

    private Set<ChunkPos> psToChunkPos(Set<PS> positions) {
        return positions.stream().map(this::psToChunkPos).collect(Collectors.toSet());
    }

    private ChunkPos psToChunkPos(PS ps) {
        return ChunkPos.of((String)ps.getWorld(), (int)ps.getChunkX(), (int)ps.getChunkZ());
    }

    private /* synthetic */ void lambda$onClaim$0(Multimap claims, Faction faction, Set chunks) {
        claims.putAll((Object)faction.getId(), this.psToChunkPos(chunks));
    }
}

