/*
 * Decompiled with CFR 0.152.
 */
package com.example.plugin;

import java.util.Optional;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.manager.WorthManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class FactionsTopApi {
    private FactionsTopApi() {
        throw new IllegalStateException();
    }

    public static Optional<Plugin> getPlugin() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("FactionsTop");
        if (plugin != null && plugin.isEnabled()) {
            try {
                return plugin instanceof FactionsTopPlugin ? Optional.of(plugin) : Optional.empty();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getId(Player member) {
        return FactionsTopApi.getPlugin().map(plugin -> ((FactionsTopPlugin)plugin).getFactionsHook().getFaction(member));
    }

    public static Optional<String> getId(Location location) {
        return FactionsTopApi.getPlugin().map(plugin -> ((FactionsTopPlugin)plugin).getFactionsHook().getFactionAt(location.getBlock()));
    }

    public static Optional<Worth> getWorth(String factionId) {
        return FactionsTopApi.getPlugin().map(plugin -> ((FactionsTopPlugin)plugin).getWorthManager().getWorth(factionId)).map(x$0 -> new Worth((FactionWorth)x$0));
    }

    public static Optional<Integer> getRank(String factionId) {
        return FactionsTopApi.getPlugin().map(plugin -> {
            WorthManager manager = ((FactionsTopPlugin)plugin).getWorthManager();
            FactionWorth worth = manager.getWorth(factionId);
            int index = manager.getOrderedFactions().indexOf((Object)worth);
            return index < 0 ? null : Integer.valueOf(index + 1);
        });
    }

    public static class Worth {
        private final FactionWorth worth;

        private Worth(FactionWorth worth) {
            this.worth = worth;
        }

        public String getName() {
            return this.worth.getName();
        }

        public double getTotal() {
            return this.worth.getTotalWorth();
        }

        public double getTotal(WorthType type) {
            return this.worth.getWorth(type);
        }

        public int getTotalSpawners() {
            return this.worth.getTotalSpawnerCount();
        }

        public int getSpawnerCount(EntityType type) {
            return (Integer)this.worth.getSpawners().get(type);
        }

        public int getMaterialCount(Material material) {
            return (Integer)this.worth.getMaterials().get(material);
        }
    }
}

