/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.util;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.novucs.ftop.util.TreeIterator;

public class SplaySet<E>
extends AbstractSet<E>
implements Set<E> {
    private final Comparator<E> comparator;
    private int size = 0;
    private Node<E> root;

    private SplaySet(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public static <E extends Comparable<E>> SplaySet<E> create() {
        return new SplaySet(Comparator.naturalOrder());
    }

    public static <E> SplaySet<E> create(Comparator<E> comparator) {
        return new SplaySet<E>(comparator);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
    }

    @Override
    public boolean add(E element) {
        Node previous = null;
        Node current = this.root;
        while (current != null) {
            current.size++;
            previous = current;
            int comparison = this.comparator.compare(current.element, element);
            if (comparison < 0) {
                current = current.right;
                continue;
            }
            if (comparison == 0 && element.equals(current.element)) {
                while (previous != null) {
                    previous.size--;
                    previous = previous.parent;
                }
                return false;
            }
            current = current.left;
        }
        current = new Node(element);
        current.parent = previous;
        if (previous == null) {
            this.root = current;
        } else if (this.comparator.compare(previous.element, current.element) < 0) {
            previous.right = current;
        } else {
            previous.left = current;
        }
        this.splay(current);
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Node<Object> node = this.find(o);
        return node != null && this.removeNode(node);
    }

    private boolean removeNode(Node<E> node) {
        this.splay(node);
        Node left = ((Node)node).left;
        Node right = ((Node)node).right;
        Node<E> max = null;
        if (left != null) {
            left.parent = null;
            max = this.maximumSubtree(left);
            this.splay(max);
            ((Node)max).size = ((Node)node).size - 1;
            this.root = max;
        }
        if (right != null) {
            if (left != null) {
                ((Node)max).right = right;
            } else {
                this.root = right;
            }
            right.parent = (Node)max;
        }
        if (right == null && left == null) {
            this.root = null;
        }
        --this.size;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        Node<Object> node = this.find(o);
        return node != null;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator(this, this.minimumSubtree(this.root));
    }

    public Iterator<E> iterator(int index) {
        return new Iterator(this, this.nodeByIndex(index));
    }

    public E last() {
        return (E)(this.root == null ? null : ((Node)this.minimumSubtree(this.root)).element);
    }

    public E first() {
        return (E)(this.root == null ? null : ((Node)this.maximumSubtree(this.root)).element);
    }

    private Node<E> find(E element) {
        Node node = this.root;
        while (node != null) {
            int comparison = this.comparator.compare(node.element, element);
            if (comparison > 0) {
                node = node.left;
                continue;
            }
            if (comparison == 0 && element.equals(node.element)) {
                return node;
            }
            node = node.right;
        }
        return null;
    }

    public E byIndex(int index) {
        return (E)((Node)this.nodeByIndex(index)).element;
    }

    public int indexOf(E element) {
        int rank;
        Node node = this.find(element);
        if (node == null) {
            return -1;
        }
        int n = rank = node.left == null ? 0 : node.left.size;
        while (node.parent != null) {
            if (node.parent.left != node) {
                rank += node.parent.left == null ? 1 : node.parent.left.size + 1;
            }
            node = node.parent;
        }
        return rank;
    }

    private Node<E> nodeByIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Size: " + this.size + "; Accessed: " + index);
        }
        Node current = this.root;
        while (current != null) {
            int length;
            int n = length = current.left == null ? 0 : current.left.size;
            if (index == length) {
                return current;
            }
            if (index < length) {
                current = current.left;
                continue;
            }
            current = current.right;
            index -= length + 1;
        }
        throw new IllegalStateException();
    }

    private void rotateLeft(Node<E> node) {
        Node target = ((Node)node).right;
        int laterSize = 0;
        if (target != null) {
            ((Node)node).right = target.left;
            if (target.left != null) {
                target.left.parent = (Node)node;
                laterSize = target.left.size;
            }
            target.parent = ((Node)node).parent;
        }
        if (((Node)node).parent == null) {
            this.root = target;
        } else if (node == ((Node)node).parent.left) {
            ((Node)node).parent.left = target;
        } else {
            ((Node)node).parent.right = target;
        }
        if (target != null) {
            target.left = (Node)node;
            ((Node)node).size -= target.size;
            target.size += ((Node)node).size;
        }
        ((Node)node).size += laterSize;
        ((Node)node).parent = target;
    }

    private void rotateRight(Node<E> node) {
        Node target = ((Node)node).left;
        int laterSize = 0;
        if (target != null) {
            ((Node)node).left = target.right;
            if (target.right != null) {
                target.right.parent = (Node)node;
                laterSize = target.right.size;
            }
            target.parent = ((Node)node).parent;
        }
        if (((Node)node).parent == null) {
            this.root = target;
        } else if (node == ((Node)node).parent.left) {
            ((Node)node).parent.left = target;
        } else {
            ((Node)node).parent.right = target;
        }
        if (target != null) {
            target.right = (Node)node;
            ((Node)node).size -= target.size;
            target.size += ((Node)node).size;
        }
        ((Node)node).size += laterSize;
        ((Node)node).parent = target;
    }

    private void splay(Node<E> node) {
        if (node == null) {
            return;
        }
        while (((Node)node).parent != null) {
            boolean parentRight;
            if (((Node)node).parent.parent == null) {
                if (node == ((Node)node).parent.left) {
                    this.rotateRight(((Node)node).parent);
                    continue;
                }
                this.rotateLeft(((Node)node).parent);
                continue;
            }
            boolean nodeLeft = node == ((Node)node).parent.left;
            boolean nodeRight = node == ((Node)node).parent.right;
            boolean parentLeft = ((Node)node).parent == ((Node)node).parent.parent.left;
            boolean bl = parentRight = ((Node)node).parent == ((Node)node).parent.parent.right;
            if (nodeLeft && parentLeft) {
                this.rotateRight(((Node)node).parent.parent);
                this.rotateRight(((Node)node).parent);
                continue;
            }
            if (nodeRight && parentRight) {
                this.rotateLeft(((Node)node).parent.parent);
                this.rotateLeft(((Node)node).parent);
                continue;
            }
            if (nodeLeft && parentRight) {
                this.rotateRight(((Node)node).parent);
                this.rotateLeft(((Node)node).parent);
                continue;
            }
            this.rotateLeft(((Node)node).parent);
            this.rotateRight(((Node)node).parent);
        }
    }

    private Node<E> minimumSubtree(Node<E> node) {
        while (node.left != null) {
            node = node.left;
        }
        return node;
    }

    private Node<E> maximumSubtree(Node<E> node) {
        while (node.right != null) {
            node = node.right;
        }
        return node;
    }

    private static <E> Node<E> successor(Node<E> node) {
        if (node == null) {
            return null;
        }
        if (node.right != null) {
            Node successor = node.right;
            while (successor.left != null) {
                successor = successor.left;
            }
            return successor;
        }
        Node parent = node.parent;
        Node child = node;
        while (parent != null && child == parent.right) {
            child = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static <E> Node<E> predecessor(Node<E> node) {
        if (node == null) {
            return null;
        }
        if (node.left != null) {
            Node predecessor = node.left;
            while (predecessor.right != null) {
                predecessor = predecessor.right;
            }
            return predecessor;
        }
        Node parent = node.parent;
        Node child = node;
        while (parent != null && child == parent.left) {
            child = parent;
            parent = parent.parent;
        }
        return parent;
    }

    @Override
    public String toString() {
        return "SplaySet{comparator=" + this.comparator + ", size=" + this.size + ", root=" + this.root + '}';
    }

    private static class Node<E> {
        private E element;
        private Node<E> parent;
        private Node<E> left;
        private Node<E> right;
        private int size = 1;

        private Node(E element) {
            this.element = element;
        }

        public E getElement() {
            return this.element;
        }

        public Node<E> getParent() {
            return this.parent;
        }

        public Node<E> getLeft() {
            return this.left;
        }

        public Node<E> getRight() {
            return this.right;
        }

        public int getSize() {
            return this.size;
        }

        public String toString() {
            return "Node{element=" + this.element + ", left=" + this.left + ", right=" + this.right + ", size=" + this.size + '}';
        }
    }

    public static class Iterator<E>
    implements TreeIterator<E> {
        private final SplaySet<E> tree;
        private Node<E> next;
        private Node<E> prev;
        private Node<E> current;

        private Iterator(SplaySet<E> tree, Node<E> first) {
            this.tree = tree;
            this.next = first;
            this.prev = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != null;
        }

        @Override
        public E next() {
            this.current = this.next;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.current;
            this.next = SplaySet.successor(this.current);
            return (E)((Node)this.current).element;
        }

        @Override
        public E previous() {
            this.current = this.prev;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.next = this.current;
            this.prev = SplaySet.predecessor(this.current);
            return (E)((Node)this.current).element;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException("No element selected to remove");
            }
            ((SplaySet)this.tree).removeNode(this.current);
            this.current = null;
        }
    }
}

