/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.task;

import java.util.Stack;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.RecalculateReason;
import net.novucs.ftop.entity.ChunkPos;
import org.bukkit.Chunk;
import org.bukkit.plugin.Plugin;

public class RecalculateTask
implements PluginService,
Runnable {
    private final FactionsTopPlugin plugin;
    private final Stack<ChunkPos> toRecalculate = new Stack();
    private int taskId;

    public RecalculateTask(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        if (this.isRunning()) {
            throw new IllegalStateException("Recalculation task is already running");
        }
        this.toRecalculate.addAll(this.plugin.getFactionsHook().getClaims());
        this.taskId = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, 1L, 1L).getTaskId();
        this.plugin.getServer().broadcastMessage(this.plugin.getSettings().getRecalculationStartMessage());
    }

    @Override
    public void terminate() {
        if (!this.isRunning()) {
            throw new IllegalStateException("No recalculation task was running");
        }
        this.toRecalculate.clear();
        this.plugin.getServer().getScheduler().cancelTask(this.taskId);
        this.plugin.getServer().broadcastMessage(this.plugin.getSettings().getRecalculationStopMessage());
    }

    public boolean isRunning() {
        return !this.toRecalculate.isEmpty();
    }

    @Override
    public void run() {
        int counter = this.plugin.getSettings().getRecalculateChunksPerTick();
        while (this.isRunning() && counter-- > 0) {
            ChunkPos pos = this.toRecalculate.pop();
            Chunk chunk = pos.getChunk(this.plugin.getServer());
            if (chunk == null || !chunk.load()) continue;
            this.plugin.getWorthManager().recalculate(chunk, RecalculateReason.COMMAND);
        }
        if (!this.isRunning()) {
            this.plugin.getWorthManager().updateAllFactions();
            this.plugin.getServer().getScheduler().cancelTask(this.taskId);
            this.plugin.getServer().broadcastMessage(this.plugin.getSettings().getRecalculationFinishMessage());
        }
    }
}

