/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.shade.mkremins.fanciful;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.novucs.ftop.shade.mkremins.fanciful.shaded.gson.stream.JsonWriter;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public abstract class TextualComponent
implements Cloneable {
    public String toString() {
        return this.getReadableString();
    }

    public abstract String getKey();

    public abstract String getReadableString();

    public abstract TextualComponent clone() throws CloneNotSupportedException;

    public abstract void writeJson(JsonWriter var1) throws IOException;

    static TextualComponent deserialize(Map<String, Object> map) {
        if (map.containsKey("key") && map.size() == 2 && map.containsKey("value")) {
            return ArbitraryTextTypeComponent.deserialize(map);
        }
        if (map.size() >= 2 && map.containsKey("key") && !map.containsKey("value")) {
            return ComplexTextTypeComponent.deserialize(map);
        }
        return null;
    }

    static boolean isTextKey(String key) {
        return key.equals("translate") || key.equals("text") || key.equals("score") || key.equals("selector");
    }

    static boolean isTranslatableText(TextualComponent component) {
        return component instanceof ComplexTextTypeComponent && ((ComplexTextTypeComponent)component).getKey().equals("translate");
    }

    public static TextualComponent rawText(String textValue) {
        return new ArbitraryTextTypeComponent("text", textValue);
    }

    public static TextualComponent localizedText(String translateKey) {
        return new ArbitraryTextTypeComponent("translate", translateKey);
    }

    private static void throwUnsupportedSnapshot() {
        throw new UnsupportedOperationException("This feature is only supported in snapshot releases.");
    }

    public static TextualComponent objectiveScore(String scoreboardObjective) {
        return TextualComponent.objectiveScore("*", scoreboardObjective);
    }

    public static TextualComponent objectiveScore(String playerName, String scoreboardObjective) {
        TextualComponent.throwUnsupportedSnapshot();
        return new ComplexTextTypeComponent("score", (Map<String, String>)ImmutableMap.builder().put((Object)"name", (Object)playerName).put((Object)"objective", (Object)scoreboardObjective).build());
    }

    public static TextualComponent selector(String selector) {
        TextualComponent.throwUnsupportedSnapshot();
        return new ArbitraryTextTypeComponent("selector", selector);
    }

    static {
        ConfigurationSerialization.registerClass(ArbitraryTextTypeComponent.class);
        ConfigurationSerialization.registerClass(ComplexTextTypeComponent.class);
    }

    private static final class ComplexTextTypeComponent
    extends TextualComponent
    implements ConfigurationSerializable {
        private String _key;
        private Map<String, String> _value;

        public ComplexTextTypeComponent(String key, Map<String, String> values) {
            this.setKey(key);
            this.setValue(values);
        }

        @Override
        public String getKey() {
            return this._key;
        }

        public void setKey(String key) {
            Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"The key must be specified.");
            this._key = key;
        }

        public Map<String, String> getValue() {
            return this._value;
        }

        public void setValue(Map<String, String> value) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"The value must be specified.");
            this._value = value;
        }

        @Override
        public TextualComponent clone() throws CloneNotSupportedException {
            return new ComplexTextTypeComponent(this.getKey(), this.getValue());
        }

        @Override
        public void writeJson(JsonWriter writer) throws IOException {
            writer.name(this.getKey());
            writer.beginObject();
            for (Map.Entry<String, String> jsonPair : this._value.entrySet()) {
                writer.name(jsonPair.getKey()).value(jsonPair.getValue());
            }
            writer.endObject();
        }

        public Map<String, Object> serialize() {
            return new HashMap<String, Object>(){
                {
                    this.put("key", ComplexTextTypeComponent.this.getKey());
                    for (Map.Entry<String, String> valEntry : ComplexTextTypeComponent.this.getValue().entrySet()) {
                        this.put("value." + valEntry.getKey(), valEntry.getValue());
                    }
                }
            };
        }

        public static ComplexTextTypeComponent deserialize(Map<String, Object> map) {
            String key = null;
            HashMap<String, String> value = new HashMap<String, String>();
            for (Map.Entry<String, Object> valEntry : map.entrySet()) {
                if (valEntry.getKey().equals("key")) {
                    key = (String)valEntry.getValue();
                    continue;
                }
                if (!valEntry.getKey().startsWith("value.")) continue;
                value.put(valEntry.getKey().substring(6), valEntry.getValue().toString());
            }
            return new ComplexTextTypeComponent(key, value);
        }

        @Override
        public String getReadableString() {
            return this.getKey();
        }
    }

    private static final class ArbitraryTextTypeComponent
    extends TextualComponent
    implements ConfigurationSerializable {
        private String _key;
        private String _value;

        public ArbitraryTextTypeComponent(String key, String value) {
            this.setKey(key);
            this.setValue(value);
        }

        @Override
        public String getKey() {
            return this._key;
        }

        public void setKey(String key) {
            Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"The key must be specified.");
            this._key = key;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"The value must be specified.");
            this._value = value;
        }

        @Override
        public TextualComponent clone() throws CloneNotSupportedException {
            return new ArbitraryTextTypeComponent(this.getKey(), this.getValue());
        }

        @Override
        public void writeJson(JsonWriter writer) throws IOException {
            writer.name(this.getKey()).value(this.getValue());
        }

        public Map<String, Object> serialize() {
            return new HashMap<String, Object>(){
                {
                    this.put("key", ArbitraryTextTypeComponent.this.getKey());
                    this.put("value", ArbitraryTextTypeComponent.this.getValue());
                }
            };
        }

        public static ArbitraryTextTypeComponent deserialize(Map<String, Object> map) {
            return new ArbitraryTextTypeComponent(map.get("key").toString(), map.get("value").toString());
        }

        @Override
        public String getReadableString() {
            return this.getValue();
        }
    }
}

