/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.manager;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.entity.BlockPos;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.util.SplaySet;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SignManager
extends BukkitRunnable
implements PluginService,
Listener {
    private static final Pattern signRegex = Pattern.compile("\\[f(|actions)top\\]");
    private final FactionsTopPlugin plugin;
    private final Multimap<Integer, BlockPos> signs = HashMultimap.create();
    private final Map<Integer, Double> previous = new HashMap<Integer, Double>();

    public SignManager(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    public void setSigns(Multimap<Integer, BlockPos> signs) {
        this.signs.clear();
        this.signs.putAll(signs);
    }

    @Override
    public void initialize() {
        int ticks = this.plugin.getSettings().getSignUpdateTicks();
        this.runTaskTimer((Plugin)this.plugin, ticks, ticks);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void terminate() {
        this.cancel();
        HandlerList.unregisterAll((Listener)this);
    }

    public void run() {
        SplaySet<FactionWorth> factions = this.plugin.getWorthManager().getOrderedFactions();
        for (Map.Entry entry : this.signs.asMap().entrySet()) {
            if ((Integer)entry.getKey() >= factions.size()) continue;
            FactionWorth worth = factions.byIndex((Integer)entry.getKey());
            double previousWorth = this.previous.getOrDefault(entry.getKey(), 0.0);
            if (previousWorth == worth.getTotalWorth()) continue;
            this.previous.put((Integer)entry.getKey(), worth.getTotalWorth());
            for (BlockPos pos : (Collection)entry.getValue()) {
                Block block = pos.getBlock(this.plugin.getServer());
                if (block == null || !(block.getState() instanceof Sign)) {
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.removeSign(pos));
                    continue;
                }
                Sign sign = (Sign)block.getState();
                sign.setLine(2, worth.getName());
                sign.setLine(3, this.plugin.getSettings().getCurrencyFormat().format(worth.getTotalWorth()));
                sign.update();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void registerSign(SignChangeEvent event) {
        int rank;
        if (!event.getPlayer().hasPermission("factionstop.sign.create") || !signRegex.matcher(event.getLine(0).toLowerCase()).find()) {
            return;
        }
        try {
            rank = Integer.parseInt(event.getLine(1));
        }
        catch (NumberFormatException e) {
            event.getPlayer().sendMessage(ChatColor.RED + "Invalid rank number on line 2!");
            event.setLine(0, ChatColor.DARK_RED + "[FactionsTop]");
            return;
        }
        event.setLine(0, ChatColor.DARK_BLUE + "[FactionsTop]");
        event.setLine(1, "#" + Math.max(rank, 1));
        rank = Math.max(rank - 1, 0);
        SplaySet<FactionWorth> factions = this.plugin.getWorthManager().getOrderedFactions();
        if (factions.size() > rank) {
            FactionWorth worth = factions.byIndex(rank);
            event.setLine(2, worth.getName());
            event.setLine(3, this.plugin.getSettings().getCurrencyFormat().format(worth.getTotalWorth()));
        } else {
            event.setLine(2, "-");
            event.setLine(3, "$0.00");
        }
        this.saveSign(BlockPos.of(event.getBlock()), rank);
    }

    private void saveSign(BlockPos pos, int rank) {
        this.signs.put((Object)rank, (Object)pos);
        this.plugin.getPersistenceTask().queueCreatedSign(pos, rank);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void unregisterSign(BlockBreakEvent event) {
        BlockPos pos = BlockPos.of(event.getBlock());
        if (!this.signs.containsValue((Object)pos)) {
            return;
        }
        if (!(event.getBlock().getState() instanceof Sign)) {
            this.removeSign(pos);
            return;
        }
        if (!event.getPlayer().hasPermission("factionstop.sign.break")) {
            event.getPlayer().sendMessage(this.plugin.getSettings().getPermissionMessage());
            event.setCancelled(true);
            return;
        }
        this.removeSign(pos);
    }

    private void removeSign(BlockPos pos) {
        this.signs.values().remove(pos);
        this.plugin.getPersistenceTask().queueDeletedSign(pos);
    }
}

