/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.listener;

import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.gui.GuiContext;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;

public class GuiListener
implements Listener,
PluginService {
    private final FactionsTopPlugin plugin;

    public GuiListener(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void terminate() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void registerClick(InventoryClickEvent event) {
        GuiContext context = this.plugin.getGuiManager().getContext(event.getClickedInventory());
        if (context == null) {
            return;
        }
        event.setCancelled(true);
        if (context.getSlots().size() >= event.getSlot()) {
            context.getSlots().get(event.getSlot()).handleClick(context);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void denyMovement(InventoryClickEvent event) {
        GuiContext context = this.plugin.getGuiManager().getContext(event.getInventory());
        if (context != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void unloadInventory(InventoryCloseEvent event) {
        this.plugin.getGuiManager().unloadGui(event.getInventory());
    }
}

