/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.hook.FactionsHook;
import net.novucs.ftop.hook.event.FactionClaimEvent;
import net.novucs.ftop.hook.event.FactionDisbandEvent;
import net.novucs.ftop.hook.event.FactionJoinEvent;
import net.novucs.ftop.hook.event.FactionLeaveEvent;
import net.novucs.ftop.hook.event.FactionRenameEvent;
import net.redstoneore.legacyfactions.FLocation;
import net.redstoneore.legacyfactions.RelationParticipator;
import net.redstoneore.legacyfactions.entity.Board;
import net.redstoneore.legacyfactions.entity.FPlayer;
import net.redstoneore.legacyfactions.entity.FPlayerColl;
import net.redstoneore.legacyfactions.entity.Faction;
import net.redstoneore.legacyfactions.entity.FactionColl;
import net.redstoneore.legacyfactions.event.EventFactionsChange;
import net.redstoneore.legacyfactions.event.EventFactionsDisband;
import net.redstoneore.legacyfactions.event.EventFactionsLandChange;
import net.redstoneore.legacyfactions.event.EventFactionsNameChange;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class LegacyFactions0103
extends FactionsHook {
    private final Set<ChunkPos> recentlyClaimedChunks = new HashSet<ChunkPos>();

    public LegacyFactions0103(Plugin plugin) {
        super(plugin);
    }

    @Override
    public String getFactionAt(String worldName, int chunkX, int chunkZ) {
        Faction faction = Board.get().getFactionAt(new FLocation(worldName, chunkX, chunkZ));
        return faction.getId();
    }

    @Override
    public void initialize() {
        this.getPlugin().getServer().getScheduler().runTaskTimer(this.getPlugin(), this.recentlyClaimedChunks::clear, 1L, 1L);
        super.initialize();
    }

    @Override
    public String getFaction(Player player) {
        return FPlayerColl.get((Object)player).getFaction().getId();
    }

    @Override
    public String getFactionName(String factionId) {
        return FactionColl.get().getFactionById(factionId).getTag();
    }

    @Override
    public boolean isFaction(String factionId) {
        return FactionColl.get().getFactionById(factionId) != null;
    }

    @Override
    public ChatColor getRelation(Player player, String factionId) {
        FPlayer fplayer = FPlayerColl.get((Object)player);
        Faction faction = FactionColl.get().getFactionById(factionId);
        return fplayer.getFaction().getRelationTo((RelationParticipator)faction).getColor();
    }

    @Override
    public String getOwnerName(String factionId) {
        Faction faction = FactionColl.get().getFactionById(factionId);
        if (faction == null) {
            return null;
        }
        FPlayer owner = faction.getOwner();
        return owner == null ? null : owner.getName();
    }

    @Override
    public List<UUID> getMembers(String factionId) {
        return FactionColl.get().getFactionById(factionId).getFPlayers().stream().map(fplayer -> UUID.fromString(fplayer.getId())).collect(Collectors.toList());
    }

    @Override
    public List<ChunkPos> getClaims() {
        LinkedList<ChunkPos> target = new LinkedList<ChunkPos>();
        target.addAll(this.getChunkPos(Board.get().getAllClaims()));
        return target;
    }

    @Override
    public Set<String> getFactionIds() {
        return FactionColl.all().stream().map(Faction::getId).collect(Collectors.toSet());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDisband(EventFactionsDisband event) {
        String factionId = event.getFaction().getId();
        String factionName = event.getFaction().getTag();
        this.callEvent(new FactionDisbandEvent(factionId, factionName));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRename(EventFactionsNameChange event) {
        String factionId = event.getFaction().getId();
        String oldName = event.getFaction().getTag();
        String newName = event.getFactionTag();
        this.callEvent(new FactionRenameEvent(factionId, oldName, newName));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(EventFactionsLandChange event) {
        String factionId = event.getFPlayer().getFactionId();
        if (event.getCause() == EventFactionsLandChange.LandChangeCause.Claim) {
            HashMultimap claims = HashMultimap.create();
            for (Map.Entry transaction : event.getTransactions().entrySet()) {
                String oldFactionId = Board.get().getFactionAt((FLocation)transaction.getKey()).getId();
                ChunkPos pos = this.getChunkPos((FLocation)transaction.getKey());
                if (this.recentlyClaimedChunks.contains(pos)) continue;
                this.recentlyClaimedChunks.add(pos);
                claims.put((Object)oldFactionId, (Object)pos);
            }
            this.callEvent(new FactionClaimEvent(factionId, (Multimap<String, ChunkPos>)claims));
        } else {
            HashMultimap claims = HashMultimap.create();
            for (Map.Entry transaction : event.getTransactions().entrySet()) {
                claims.put((Object)factionId, (Object)this.getChunkPos((FLocation)transaction.getKey()));
            }
            String newFactionId = FactionColl.get().getWilderness().getId();
            this.callEvent(new FactionClaimEvent(newFactionId, (Multimap<String, ChunkPos>)claims));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChangeFaction(EventFactionsChange event) {
        Player player = event.getFPlayer().getPlayer();
        this.callEvent(new FactionJoinEvent(event.getFactionNew().getId(), player));
        this.callEvent(new FactionLeaveEvent(event.getFactionOld().getId(), player));
    }

    private Set<ChunkPos> getChunkPos(Set<FLocation> locations) {
        return locations.stream().map(this::getChunkPos).collect(Collectors.toSet());
    }

    private ChunkPos getChunkPos(FLocation location) {
        return ChunkPos.of(location.getWorldName(), (int)location.getX(), (int)location.getZ());
    }
}

