/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.event.FPlayerJoinEvent;
import com.massivecraft.factions.event.FPlayerLeaveEvent;
import com.massivecraft.factions.event.LandClaimEvent;
import com.massivecraft.factions.event.LandUnclaimAllEvent;
import com.massivecraft.factions.event.LandUnclaimEvent;
import com.massivecraft.factions.iface.RelationParticipator;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.hook.FactionsHook;
import net.novucs.ftop.hook.event.FactionClaimEvent;
import net.novucs.ftop.hook.event.FactionDisbandEvent;
import net.novucs.ftop.hook.event.FactionJoinEvent;
import net.novucs.ftop.hook.event.FactionLeaveEvent;
import net.novucs.ftop.hook.event.FactionRenameEvent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class Factions0106
extends FactionsHook {
    private Map<FLocation, String> flocationIds;
    private Map<String, Faction> factions;

    public Factions0106(Plugin plugin) {
        super(plugin);
    }

    @Override
    public String getFactionAt(String worldName, int chunkX, int chunkZ) {
        Faction faction = Board.getInstance().getFactionAt(new FLocation(worldName, chunkX, chunkZ));
        return faction == null ? Factions.getInstance().getNone().getId() : faction.getId();
    }

    @Override
    public void initialize() {
        try {
            Class<?> memoryBoardClass = this.getFactionsClass("MemoryBoard");
            Class<?> memoryFactionsClass = this.getFactionsClass("MemoryFactions");
            Field flocationIdsField = memoryBoardClass.getDeclaredField("flocationIds");
            flocationIdsField.setAccessible(true);
            this.flocationIds = (Map)flocationIdsField.get(Board.getInstance());
            flocationIdsField.setAccessible(false);
            Field factionsField = memoryFactionsClass.getDeclaredField("factions");
            factionsField.setAccessible(true);
            this.factions = (Map)factionsField.get(Factions.getInstance());
            factionsField.setAccessible(false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
            this.getPlugin().getLogger().severe("Factions version found is incompatible!");
            Plugin factions = this.getPlugin().getServer().getPluginManager().getPlugin("Factions");
            if (factions != null) {
                this.getPlugin().getLogger().info("Installed Factions version: " + factions.getDescription().getVersion() + " by " + factions.getDescription().getAuthors());
            }
            this.getPlugin().getServer().getPluginManager().disablePlugin(this.getPlugin());
            return;
        }
        super.initialize();
    }

    private Class<?> getFactionsClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName("com.massivecraft.factions.data." + name);
        }
        catch (ClassNotFoundException e) {
            return Class.forName("com.massivecraft.factions.zcore.persist." + name);
        }
    }

    @Override
    public String getFaction(Player player) {
        return FPlayers.getInstance().getByPlayer(player).getFaction().getId();
    }

    @Override
    public String getFactionName(String factionId) {
        return Factions.getInstance().getFactionById(factionId).getTag();
    }

    @Override
    public boolean isFaction(String factionId) {
        return Factions.getInstance().getFactionById(factionId) != null;
    }

    @Override
    public ChatColor getRelation(Player player, String factionId) {
        FPlayer fplayer = FPlayers.getInstance().getByPlayer(player);
        Faction faction = Factions.getInstance().getFactionById(factionId);
        return fplayer.getFaction().getRelationTo((RelationParticipator)faction).getColor();
    }

    @Override
    public String getOwnerName(String factionId) {
        Faction faction = Factions.getInstance().getFactionById(factionId);
        if (faction == null) {
            return null;
        }
        FPlayer owner = faction.getFPlayerAdmin();
        return owner == null ? null : owner.getName();
    }

    @Override
    public List<UUID> getMembers(String factionId) {
        return Factions.getInstance().getFactionById(factionId).getFPlayers().stream().map(fplayer -> UUID.fromString(fplayer.getId())).collect(Collectors.toList());
    }

    @Override
    public List<ChunkPos> getClaims() {
        LinkedList<ChunkPos> target = new LinkedList<ChunkPos>();
        target.addAll(this.getChunkPos(this.flocationIds.keySet()));
        return target;
    }

    @Override
    public Set<String> getFactionIds() {
        return this.factions.keySet();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDisband(com.massivecraft.factions.event.FactionDisbandEvent event) {
        String factionId = event.getFaction().getId();
        String factionName = event.getFaction().getTag();
        this.callEvent(new FactionDisbandEvent(factionId, factionName));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRename(com.massivecraft.factions.event.FactionRenameEvent event) {
        String factionId = event.getFaction().getId();
        String oldName = event.getfPlayer().getFaction().getTag();
        String newName = event.getFactionTag();
        this.callEvent(new FactionRenameEvent(factionId, oldName, newName));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(LandClaimEvent event) {
        Faction faction = Board.getInstance().getFactionAt(event.getLocation());
        HashMultimap claims = HashMultimap.create();
        claims.put((Object)faction.getId(), (Object)this.getChunkPos(event.getLocation()));
        this.callEvent(new FactionClaimEvent(event.getFaction().getId(), (Multimap<String, ChunkPos>)claims));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(LandUnclaimEvent event) {
        HashMultimap claims = HashMultimap.create();
        claims.put((Object)event.getFaction().getId(), (Object)this.getChunkPos(event.getLocation()));
        this.callEvent(new FactionClaimEvent(Factions.getInstance().getNone().getId(), (Multimap<String, ChunkPos>)claims));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onClaim(LandUnclaimAllEvent event) {
        HashMultimap claims = HashMultimap.create();
        for (FLocation location : event.getFaction().getClaimOwnership().keySet()) {
            claims.put((Object)event.getFaction().getId(), (Object)this.getChunkPos(location));
        }
        this.callEvent(new FactionClaimEvent(Factions.getInstance().getNone().getId(), (Multimap<String, ChunkPos>)claims));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(FPlayerJoinEvent event) {
        Player player = event.getfPlayer().getPlayer();
        String factionId = event.getFaction().getId();
        this.callEvent(new FactionJoinEvent(factionId, player));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLeave(FPlayerLeaveEvent event) {
        Player player = event.getfPlayer().getPlayer();
        String factionId = event.getFaction().getId();
        if (player != null) {
            this.callEvent(new FactionLeaveEvent(factionId, player));
        }
    }

    private Set<ChunkPos> getChunkPos(Set<FLocation> locations) {
        return locations.stream().map(this::getChunkPos).collect(Collectors.toSet());
    }

    private ChunkPos getChunkPos(FLocation location) {
        return ChunkPos.of(location.getWorldName(), (int)location.getX(), (int)location.getZ());
    }
}

