/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.api.UserDoesNotExistException;
import java.util.List;
import java.util.UUID;
import net.ess3.api.Economy;
import net.ess3.api.events.UserBalanceUpdateEvent;
import net.novucs.ftop.hook.EconomyHook;
import net.novucs.ftop.hook.FactionsHook;
import net.novucs.ftop.hook.event.FactionEconomyEvent;
import net.novucs.ftop.hook.event.PlayerEconomyEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EssentialsEconomyHook
implements EconomyHook,
Listener {
    private final Plugin plugin;
    private final FactionsHook factionsHook;
    private boolean playerEnabled;
    private boolean factionEnabled;
    private IEssentials essentials = null;

    public EssentialsEconomyHook(Plugin plugin, FactionsHook factionsHook) {
        this.plugin = plugin;
        this.factionsHook = factionsHook;
    }

    @Override
    public void initialize() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.essentials = (IEssentials)this.plugin.getServer().getPluginManager().getPlugin("Essentials");
    }

    @Override
    public void terminate() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public void setPlayerEnabled(boolean enabled) {
        this.playerEnabled = enabled;
    }

    @Override
    public void setFactionEnabled(boolean enabled) {
        this.factionEnabled = enabled;
    }

    @Override
    public double getBalance(Player player) {
        try {
            return Economy.getMoneyExact((String)player.getName()).doubleValue();
        }
        catch (UserDoesNotExistException | NullPointerException e) {
            return 0.0;
        }
    }

    @Override
    public double getBalance(UUID playerId) {
        User user;
        try {
            user = this.essentials.getUser(playerId);
        }
        catch (NullPointerException e) {
            return 0.0;
        }
        if (user != null) {
            return user.getMoney().doubleValue();
        }
        return 0.0;
    }

    @Override
    public double getTotalBalance(List<UUID> playerIds) {
        double balance = 0.0;
        for (UUID playerId : playerIds) {
            balance += this.getBalance(playerId);
        }
        return balance;
    }

    @Override
    public double getFactionBalance(String factionId) {
        try {
            return Economy.getMoneyExact((String)("faction_" + factionId.replace("-", "_"))).doubleValue();
        }
        catch (UserDoesNotExistException e) {
            return 0.0;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEconomyEvent(UserBalanceUpdateEvent event) {
        String factionId;
        double oldBalance = event.getOldBalance().doubleValue();
        double newBalance = event.getNewBalance().doubleValue();
        Player player = event.getPlayer();
        if (!player.isOnline() && player.getName().startsWith("faction_") && this.factionsHook.isFaction(factionId = player.getName().substring(8).replace("_", "-"))) {
            if (this.factionEnabled) {
                this.callEvent(new FactionEconomyEvent(factionId, oldBalance, newBalance));
            }
            return;
        }
        try {
            if (Economy.isNPC((String)player.getName())) {
                return;
            }
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            // empty catch block
        }
        if (this.playerEnabled) {
            this.callEvent(new PlayerEconomyEvent(player, oldBalance, newBalance));
        }
    }

    private void callEvent(Event event) {
        this.plugin.getServer().getPluginManager().callEvent(event);
    }
}

