/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.novucs.ftop.hook.PlaceholderHook;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ClipPlaceholderAPIHook
implements PlaceholderHook {
    private final Plugin plugin;
    private final Function<Player, String> playerReplacer;
    private final Function<Integer, String> rankReplacer;
    private final Supplier<String> lastReplacer;
    private HashSet<Integer> enabledRanks;

    public ClipPlaceholderAPIHook(Plugin plugin, Function<Player, String> playerReplacer, Function<Integer, String> rankReplacer, Supplier<String> lastReplacer) {
        this.plugin = plugin;
        this.playerReplacer = playerReplacer;
        this.rankReplacer = rankReplacer;
        this.lastReplacer = lastReplacer;
    }

    @Override
    public boolean initialize(final List<Integer> enabledRanks) {
        this.enabledRanks = new HashSet<Integer>(enabledRanks);
        return new PlaceholderExpansion(){

            public String onPlaceholderRequest(Player player, String identifier) {
                String[] split;
                if ("name:last".equals(identifier)) {
                    return (String)ClipPlaceholderAPIHook.this.lastReplacer.get();
                }
                if ("rank:player".equals(identifier)) {
                    return (String)ClipPlaceholderAPIHook.this.playerReplacer.apply(player);
                }
                if (identifier.startsWith("name:") && (split = identifier.split(":")).length > 1) {
                    try {
                        int rank = Integer.parseInt(split[1]);
                        if (enabledRanks.contains(rank) || enabledRanks.isEmpty()) {
                            return (String)ClipPlaceholderAPIHook.this.rankReplacer.apply(rank);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }

            public boolean persist() {
                return true;
            }

            public String getIdentifier() {
                return "factionstop";
            }

            public String getAuthor() {
                return String.join((CharSequence)", ", ClipPlaceholderAPIHook.this.plugin.getDescription().getAuthors());
            }

            public String getVersion() {
                return ClipPlaceholderAPIHook.this.plugin.getDescription().getVersion();
            }
        }.register();
    }
}

