/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.gui.element.GuiElement;
import net.novucs.ftop.util.TreeIterator;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GuiContext {
    private final FactionsTopPlugin plugin;
    private final Player player;
    private final Inventory inventory;
    private final int maxPage;
    private final int thisPage;
    private final TreeIterator<FactionWorth> worthIterator;
    private final Map<String, String> placeholders;
    private final List<GuiElement> slots = new ArrayList<GuiElement>();
    private int currentRank;
    private int slot;

    public GuiContext(FactionsTopPlugin plugin, Player player, Inventory inventory, int maxPage, int thisPage, TreeIterator<FactionWorth> worthIterator, Map<String, String> placeholders) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = inventory;
        this.maxPage = maxPage;
        this.thisPage = thisPage;
        this.worthIterator = worthIterator;
        this.placeholders = placeholders;
    }

    public FactionsTopPlugin getPlugin() {
        return this.plugin;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public int getThisPage() {
        return this.thisPage;
    }

    public TreeIterator<FactionWorth> getWorthIterator() {
        return this.worthIterator;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public List<GuiElement> getSlots() {
        return this.slots;
    }

    public boolean hasNextPage() {
        return this.thisPage < this.maxPage;
    }

    public boolean hasPrevPage() {
        return this.thisPage > 1;
    }

    public int getCurrentRank() {
        return this.currentRank;
    }

    public void setCurrentRank(int currentRank) {
        this.currentRank = currentRank;
    }

    public int getAndIncrementRank() {
        return this.currentRank++;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getAndIncrementSlot() {
        return this.slot++;
    }
}

