/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.entity;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.ChunkWorth;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class FactionWorth
implements Comparable<FactionWorth> {
    private final String factionId;
    private final Map<WorthType, Double> worth = new EnumMap<WorthType, Double>(WorthType.class);
    private final Map<Material, Integer> materials = new EnumMap<Material, Integer>(Material.class);
    private final Map<EntityType, Integer> spawners = new EnumMap<EntityType, Integer>(EntityType.class);
    private String name;
    private double totalWorth = 0.0;
    private int totalSpawners = 0;

    public FactionWorth(String factionId, String name) {
        this.factionId = factionId;
        this.name = name;
    }

    public String getFactionId() {
        return this.factionId;
    }

    public double getWorth(WorthType worthType) {
        return this.worth.getOrDefault((Object)worthType, 0.0);
    }

    public Map<WorthType, Double> getWorth() {
        return this.worth;
    }

    public Map<Material, Integer> getMaterials() {
        return Collections.unmodifiableMap(this.materials);
    }

    public Map<EntityType, Integer> getSpawners() {
        return Collections.unmodifiableMap(this.spawners);
    }

    public int getTotalSpawnerCount() {
        return this.totalSpawners;
    }

    public String getName() {
        return this.name;
    }

    public double getTotalWorth() {
        return this.totalWorth;
    }

    private void setWorth(WorthType worthType, double worth) {
        Double prev = this.worth.put(worthType, worth = Math.max(0.0, worth));
        this.totalWorth += worth - (prev == null ? 0.0 : prev);
    }

    public void addWorth(WorthType worthType, double worth) {
        this.setWorth(worthType, this.getWorth(worthType) + worth);
    }

    public void addMaterials(Map<Material, Integer> materials) {
        this.add(materials, this.materials);
    }

    public void removeMaterials(Map<Material, Integer> materials) {
        this.remove(materials, this.materials);
    }

    public void addSpawners(Map<EntityType, Integer> spawners) {
        spawners.values().forEach(count -> this.totalSpawners += count.intValue());
        this.add(spawners, this.spawners);
    }

    public void removeSpawners(Map<EntityType, Integer> spawners) {
        spawners.values().forEach(count -> this.totalSpawners -= count.intValue());
        this.remove(spawners, this.spawners);
    }

    private void addWorth(Map<WorthType, Double> worth) {
        for (Map.Entry<WorthType, Double> entry : worth.entrySet()) {
            double amount = this.worth.getOrDefault((Object)entry.getKey(), 0.0);
            this.totalWorth += entry.getValue().doubleValue();
            this.worth.put(entry.getKey(), amount + entry.getValue());
        }
    }

    private <T> void add(Map<T, Integer> modifier, Map<T, Integer> modified) {
        for (Map.Entry<T, Integer> entry : modifier.entrySet()) {
            int amount = Math.max(0, modified.getOrDefault(entry.getKey(), 0) + entry.getValue());
            modified.put(entry.getKey(), amount);
        }
    }

    private <T> void remove(Map<T, Integer> modifier, Map<T, Integer> modified) {
        for (Map.Entry<T, Integer> entry : modifier.entrySet()) {
            int amount = Math.max(0, modified.getOrDefault(entry.getKey(), 0) - entry.getValue());
            modified.put(entry.getKey(), amount);
        }
    }

    public void addAll(ChunkWorth chunkWorth) {
        this.addMaterials(chunkWorth.getMaterials());
        this.addSpawners(chunkWorth.getSpawners());
        this.addWorth(chunkWorth.getWorth());
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(FactionWorth o) {
        return Double.compare(o.totalWorth, this.totalWorth);
    }

    public String toString() {
        return "FactionWorth{factionId='" + this.factionId + '\'' + ", worth=" + this.worth + ", materials=" + this.materials + ", spawners=" + this.spawners + ", name='" + this.name + '\'' + ", totalWorth=" + this.totalWorth + '}';
    }
}

