/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.IdentityCache;

public class WorthModel {
    private static final String INSERT = "INSERT INTO `worth` (`name`) VALUES(?)";
    private final List<WorthType> insertionQueue = new LinkedList<WorthType>();
    private final IdentityCache identityCache;
    private final PreparedStatement insert;

    private WorthModel(IdentityCache identityCache, PreparedStatement insert) {
        this.identityCache = identityCache;
        this.insert = insert;
    }

    public static WorthModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        return new WorthModel(identityCache, insert);
    }

    public void executeBatch() throws SQLException {
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (WorthType worthType : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            this.identityCache.setWorthId(worthType.name(), id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.insert.close();
    }

    public void addBatch(Collection<WorthType> worthTypes) throws SQLException {
        for (WorthType worthType : worthTypes) {
            this.addBatch(worthType);
        }
    }

    public void addBatch(WorthType worthType) throws SQLException {
        if (this.insertionQueue.contains((Object)worthType) || this.identityCache.hasWorth(worthType.name())) {
            return;
        }
        this.insert.setString(1, worthType.name());
        this.insert.addBatch();
        this.insertionQueue.add(worthType);
    }
}

