/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.novucs.ftop.entity.BlockPos;
import net.novucs.ftop.entity.IdentityCache;

public class SignLoader {
    private static final String SELECT_BLOCK = "SELECT * FROM `block`";
    private static final String SELECT_SIGN = "SELECT * FROM `sign`";
    private final IdentityCache identityCache;
    private final PreparedStatement selectBlock;
    private final PreparedStatement selectSign;

    public SignLoader(IdentityCache identityCache, PreparedStatement selectBlock, PreparedStatement selectSign) {
        this.identityCache = identityCache;
        this.selectBlock = selectBlock;
        this.selectSign = selectSign;
    }

    public static SignLoader of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement selectBlock = connection.prepareStatement(SELECT_BLOCK);
        PreparedStatement selectSign = connection.prepareStatement(SELECT_SIGN);
        return new SignLoader(identityCache, selectBlock, selectSign);
    }

    public Multimap<Integer, BlockPos> load() throws SQLException {
        this.loadBlock();
        return this.loadSign();
    }

    public void close() throws SQLException {
        this.selectBlock.close();
        this.selectSign.close();
    }

    private void loadBlock() throws SQLException {
        ResultSet resultSet = this.selectBlock.executeQuery();
        while (resultSet.next()) {
            int id = resultSet.getInt("id");
            int worldId = resultSet.getInt("world_id");
            int x = resultSet.getInt("x");
            int y = resultSet.getInt("y");
            int z = resultSet.getInt("z");
            this.identityCache.setBlockId(worldId, x, y, z, id);
        }
        resultSet.close();
    }

    private Multimap<Integer, BlockPos> loadSign() throws SQLException {
        ResultSet resultSet = this.selectSign.executeQuery();
        HashMultimap signs = HashMultimap.create();
        while (resultSet.next()) {
            int id = resultSet.getInt("id");
            int blockId = resultSet.getInt("block_id");
            int rank = resultSet.getInt("rank");
            this.identityCache.setSignId(blockId, id);
            this.identityCache.getBlock(blockId).ifPresent(arg_0 -> SignLoader.lambda$loadSign$0((Multimap)signs, rank, arg_0));
        }
        resultSet.close();
        return signs;
    }

    private static /* synthetic */ void lambda$loadSign$0(Multimap signs, int rank, BlockPos block) {
        signs.put((Object)rank, (Object)block);
    }
}

