/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.novucs.ftop.entity.IdentityCache;
import org.bukkit.entity.EntityType;

public class FactionSpawnerModel {
    private static final String UPDATE = "UPDATE `faction_spawner_count` SET `count` = ? WHERE `id` = ?";
    private static final String INSERT = "INSERT INTO `faction_spawner_count` (`faction_id`, `spawner_id`, `count`) VALUES (?, ?, ?)";
    private static final String DELETE = "DELETE FROM `faction_spawner_count` WHERE `faction_id` = ?";
    private final List<Map.Entry<String, Integer>> insertionQueue = new LinkedList<Map.Entry<String, Integer>>();
    private final IdentityCache identityCache;
    private final PreparedStatement update;
    private final PreparedStatement insert;
    private final PreparedStatement delete;

    private FactionSpawnerModel(IdentityCache identityCache, PreparedStatement update, PreparedStatement insert, PreparedStatement delete) {
        this.identityCache = identityCache;
        this.update = update;
        this.insert = insert;
        this.delete = delete;
    }

    public static FactionSpawnerModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement update = connection.prepareStatement(UPDATE);
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        PreparedStatement delete = connection.prepareStatement(DELETE);
        return new FactionSpawnerModel(identityCache, update, insert, delete);
    }

    public void executeBatch() throws SQLException {
        this.update.executeBatch();
        this.insert.executeBatch();
        this.delete.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (Map.Entry<String, Integer> entry : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            String factionId = entry.getKey();
            int spawnerId = entry.getValue();
            this.identityCache.setFactionSpawnerId(factionId, spawnerId, id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.delete.close();
        this.update.close();
        this.insert.close();
    }

    public void addBatch(String factionId, Map<EntityType, Integer> spawners) throws SQLException {
        for (Map.Entry<EntityType, Integer> entry : spawners.entrySet()) {
            EntityType spawner = entry.getKey();
            int count = entry.getValue();
            int spawnerId = this.identityCache.getSpawnerId(spawner.name());
            this.addBatch(factionId, spawnerId, count);
        }
    }

    public void addBatch(String factionId, int spawnerId, int count) throws SQLException {
        Integer relationId = this.identityCache.getFactionSpawnerId(factionId, spawnerId);
        AbstractMap.SimpleImmutableEntry<String, Integer> insertionKey = new AbstractMap.SimpleImmutableEntry<String, Integer>(factionId, spawnerId);
        if (relationId == null) {
            if (!this.insertionQueue.contains(insertionKey)) {
                this.insertCounter(factionId, spawnerId, count);
                this.insertionQueue.add(insertionKey);
            }
        } else {
            this.updateCounter(count, relationId);
        }
    }

    private void insertCounter(String factionId, int spawnerId, int count) throws SQLException {
        this.insert.setString(1, factionId);
        this.insert.setInt(2, spawnerId);
        this.insert.setInt(3, count);
        this.insert.addBatch();
    }

    private void updateCounter(int count, Integer relationId) throws SQLException {
        this.update.setInt(1, count);
        this.update.setInt(2, relationId);
        this.update.addBatch();
    }

    public void addBatchDelete(Collection<String> factions) throws SQLException {
        for (String factionId : factions) {
            this.addBatchDelete(factionId);
        }
    }

    public void addBatchDelete(String factionId) throws SQLException {
        this.delete.setString(1, factionId);
        this.delete.addBatch();
    }
}

