/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import net.novucs.ftop.database.FactionMaterialModel;
import net.novucs.ftop.database.FactionSpawnerModel;
import net.novucs.ftop.database.FactionWorthModel;
import net.novucs.ftop.database.MaterialModel;
import net.novucs.ftop.database.SpawnerModel;
import net.novucs.ftop.database.WorthModel;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.entity.IdentityCache;

public class FactionModel {
    private static final String UPDATE = "UPDATE `faction` SET `name` = ?, `total_worth` = ?, `total_spawners` = ? WHERE `id` = ?";
    private static final String INSERT = "INSERT INTO `faction` (`id`, `name`, `total_worth`, `total_spawners`) VALUES(?, ?, ?, ?)";
    private static final String DELETE = "DELETE FROM `faction` WHERE `id` = ?";
    private final Connection connection;
    private final IdentityCache identityCache;
    private PreparedStatement update;
    private PreparedStatement insert;
    private PreparedStatement delete;

    public FactionModel(Connection connection, IdentityCache identityCache) {
        this.connection = connection;
        this.identityCache = identityCache;
    }

    public void persist(Set<FactionWorth> factions, Set<String> deletedFactions) throws SQLException {
        this.init();
        factions.removeIf(factionWorth -> deletedFactions.contains(factionWorth.getFactionId()));
        this.persistNames(factions);
        this.persistFactions(factions);
        this.persistStatistics(factions, deletedFactions);
        this.deleteFactions(deletedFactions);
        this.close();
    }

    private void init() throws SQLException {
        this.delete = this.connection.prepareStatement(DELETE);
        this.insert = this.connection.prepareStatement(INSERT, 1);
        this.update = this.connection.prepareStatement(UPDATE);
    }

    private void close() throws SQLException {
        this.delete.close();
        this.insert.close();
        this.update.close();
    }

    private void deleteFactions(Set<String> factions) throws SQLException {
        for (String factionId : factions) {
            this.delete.setString(1, factionId);
            this.delete.addBatch();
            this.identityCache.removeFaction(factionId);
        }
        this.delete.executeBatch();
    }

    private void persistNames(Set<FactionWorth> factions) throws SQLException {
        MaterialModel materialModel = MaterialModel.of(this.connection, this.identityCache);
        SpawnerModel spawnerModel = SpawnerModel.of(this.connection, this.identityCache);
        WorthModel worthModel = WorthModel.of(this.connection, this.identityCache);
        for (FactionWorth worth : factions) {
            materialModel.addBatch(worth.getMaterials().keySet());
            spawnerModel.addBatch(worth.getSpawners().keySet());
            worthModel.addBatch(worth.getWorth().keySet());
        }
        materialModel.executeBatch();
        spawnerModel.executeBatch();
        worthModel.executeBatch();
        materialModel.close();
        spawnerModel.close();
        worthModel.close();
    }

    private void persistFactions(Set<FactionWorth> factions) throws SQLException {
        Set<FactionWorth> createdFactions = this.insertFactions(factions);
        this.cacheFactionIds(createdFactions);
    }

    private Set<FactionWorth> insertFactions(Set<FactionWorth> factions) throws SQLException {
        HashSet<FactionWorth> createdFactions = new HashSet<FactionWorth>();
        for (FactionWorth factionWorth : factions) {
            if (this.identityCache.hasFaction(factionWorth.getFactionId())) {
                this.updateFaction(factionWorth);
                continue;
            }
            this.insertFaction(createdFactions, factionWorth);
        }
        this.insert.executeBatch();
        this.update.executeBatch();
        return createdFactions;
    }

    private void updateFaction(FactionWorth faction) throws SQLException {
        this.update.setString(1, faction.getName());
        this.update.setDouble(2, faction.getTotalWorth());
        this.update.setInt(3, faction.getTotalSpawnerCount());
        this.update.setString(4, faction.getFactionId());
        this.update.addBatch();
    }

    private void insertFaction(Set<FactionWorth> createdFactions, FactionWorth factionWorth) throws SQLException {
        this.insert.setString(1, factionWorth.getFactionId());
        this.insert.setString(2, factionWorth.getName());
        this.insert.setDouble(3, factionWorth.getTotalWorth());
        this.insert.setInt(4, factionWorth.getTotalSpawnerCount());
        this.insert.addBatch();
        createdFactions.add(factionWorth);
    }

    private void cacheFactionIds(Set<FactionWorth> createdFactions) throws SQLException {
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (FactionWorth factionWorth : createdFactions) {
            if (!resultSet.next()) continue;
            this.identityCache.addFaction(factionWorth.getFactionId());
        }
        resultSet.close();
    }

    private void persistStatistics(Set<FactionWorth> factions, Set<String> deletedFactions) throws SQLException {
        FactionMaterialModel materialModel = FactionMaterialModel.of(this.connection, this.identityCache);
        FactionSpawnerModel spawnerModel = FactionSpawnerModel.of(this.connection, this.identityCache);
        FactionWorthModel worthModel = FactionWorthModel.of(this.connection, this.identityCache);
        materialModel.addBatchDelete(deletedFactions);
        spawnerModel.addBatchDelete(deletedFactions);
        worthModel.addBatchDelete(deletedFactions);
        for (FactionWorth faction : factions) {
            materialModel.addBatch(faction.getFactionId(), faction.getMaterials());
            spawnerModel.addBatch(faction.getFactionId(), faction.getSpawners());
            worthModel.addBatch(faction.getFactionId(), faction.getWorth());
        }
        materialModel.executeBatch();
        spawnerModel.executeBatch();
        worthModel.executeBatch();
        materialModel.close();
        spawnerModel.close();
        worthModel.close();
    }
}

