/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.IdentityCache;

public class ChunkWorthModel {
    private static final String UPDATE = "UPDATE `chunk_worth` SET `worth` = ? WHERE `id` = ?";
    private static final String INSERT = "INSERT INTO `chunk_worth` (`chunk_id`, `worth_id`, `worth`) VALUES(?, ?, ?)";
    private final List<Map.Entry<Integer, Integer>> insertionQueue = new LinkedList<Map.Entry<Integer, Integer>>();
    private final IdentityCache identityCache;
    private final PreparedStatement update;
    private final PreparedStatement insert;

    private ChunkWorthModel(IdentityCache identityCache, PreparedStatement update, PreparedStatement insert) {
        this.identityCache = identityCache;
        this.update = update;
        this.insert = insert;
    }

    public static ChunkWorthModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement update = connection.prepareStatement(UPDATE);
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        return new ChunkWorthModel(identityCache, update, insert);
    }

    public void executeBatch() throws SQLException {
        this.update.executeBatch();
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (Map.Entry<Integer, Integer> entry : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            int chunkId = entry.getKey();
            int worthId = entry.getValue();
            this.identityCache.setChunkWorthId(chunkId, worthId, id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.update.close();
        this.insert.close();
    }

    public void addBatch(int chunkId, Map<WorthType, Double> worth) throws SQLException {
        for (Map.Entry<WorthType, Double> entry : worth.entrySet()) {
            WorthType worthType = entry.getKey();
            double value = entry.getValue();
            int worthTypeId = this.identityCache.getWorthId(worthType.name());
            this.addBatch(chunkId, worthTypeId, value);
        }
    }

    public void addBatch(int chunkId, int worthTypeId, double value) throws SQLException {
        Integer relationId = this.identityCache.getChunkWorthId(chunkId, worthTypeId);
        AbstractMap.SimpleImmutableEntry<Integer, Integer> insertionKey = new AbstractMap.SimpleImmutableEntry<Integer, Integer>(chunkId, worthTypeId);
        if (relationId == null) {
            if (!this.insertionQueue.contains(insertionKey)) {
                this.insertCounter(chunkId, worthTypeId, value);
                this.insertionQueue.add(insertionKey);
            }
        } else {
            this.updateCounter(value, relationId);
        }
    }

    private void insertCounter(int chunkId, int worthId, double value) throws SQLException {
        this.insert.setInt(1, chunkId);
        this.insert.setInt(2, worthId);
        this.insert.setDouble(3, value);
        this.insert.addBatch();
    }

    private void updateCounter(double value, Integer relationId) throws SQLException {
        this.update.setDouble(1, value);
        this.update.setInt(2, relationId);
        this.update.addBatch();
    }
}

