/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.entity.ChunkWorth;
import net.novucs.ftop.entity.IdentityCache;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class ChunkLoader {
    private static final String SELECT_CHUNK = "SELECT * FROM `chunk`";
    private static final String SELECT_CHUNK_MATERIAL = "SELECT * FROM `chunk_material_count`";
    private static final String SELECT_CHUNK_SPAWNER = "SELECT * FROM `chunk_spawner_count`";
    private static final String SELECT_CHUNK_WORTH = "SELECT * FROM `chunk_worth`";
    private final IdentityCache identityCache;
    private final PreparedStatement selectChunk;
    private final PreparedStatement selectChunkMaterial;
    private final PreparedStatement selectChunkSpawner;
    private final PreparedStatement selectChunkWorth;

    private ChunkLoader(IdentityCache identityCache, PreparedStatement selectChunk, PreparedStatement selectChunkMaterial, PreparedStatement selectChunkSpawner, PreparedStatement selectChunkWorth) {
        this.identityCache = identityCache;
        this.selectChunk = selectChunk;
        this.selectChunkMaterial = selectChunkMaterial;
        this.selectChunkSpawner = selectChunkSpawner;
        this.selectChunkWorth = selectChunkWorth;
    }

    public static ChunkLoader of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement selectChunk = connection.prepareStatement(SELECT_CHUNK);
        PreparedStatement selectChunkMaterial = connection.prepareStatement(SELECT_CHUNK_MATERIAL);
        PreparedStatement selectChunkSpawner = connection.prepareStatement(SELECT_CHUNK_SPAWNER);
        PreparedStatement selectChunkWorth = connection.prepareStatement(SELECT_CHUNK_WORTH);
        return new ChunkLoader(identityCache, selectChunk, selectChunkMaterial, selectChunkSpawner, selectChunkWorth);
    }

    public Map<ChunkPos, ChunkWorth> load() throws SQLException {
        HashMap<ChunkPos, ChunkWorth> target = new HashMap<ChunkPos, ChunkWorth>();
        Map<Integer, ChunkPos> chunks = this.loadChunk();
        Table<Integer, Material, Integer> globalMaterialCount = this.loadChunkMaterial();
        Table<Integer, EntityType, Integer> globalSpawnerCount = this.loadChunkSpawner();
        Table<Integer, WorthType, Double> globalWorth = this.loadChunkWorth();
        for (Map.Entry<Integer, ChunkPos> entry : chunks.entrySet()) {
            int chunkId = entry.getKey();
            EnumMap<Material, Integer> chunkMaterialCount = new EnumMap<Material, Integer>(Material.class);
            chunkMaterialCount.putAll(globalMaterialCount.row((Object)chunkId));
            EnumMap<EntityType, Integer> chunkSpawnerCount = new EnumMap<EntityType, Integer>(EntityType.class);
            chunkSpawnerCount.putAll(globalSpawnerCount.row((Object)chunkId));
            EnumMap<WorthType, Double> chunkWorth = new EnumMap<WorthType, Double>(WorthType.class);
            chunkWorth.putAll(globalWorth.row((Object)chunkId));
            ChunkPos chunk = entry.getValue();
            ChunkWorth worth = new ChunkWorth(chunkWorth, chunkMaterialCount, chunkSpawnerCount);
            target.put(chunk, worth);
        }
        return target;
    }

    public void close() throws SQLException {
        this.selectChunk.close();
        this.selectChunkMaterial.close();
        this.selectChunkSpawner.close();
        this.selectChunkWorth.close();
    }

    private Map<Integer, ChunkPos> loadChunk() throws SQLException {
        HashMap<Integer, ChunkPos> target = new HashMap<Integer, ChunkPos>();
        ResultSet resultSet = this.selectChunk.executeQuery();
        while (resultSet.next()) {
            int id = resultSet.getInt("id");
            int worldId = resultSet.getInt("world_id");
            int x = resultSet.getInt("x");
            int z = resultSet.getInt("z");
            this.identityCache.setChunkPosId(worldId, x, z, id);
            this.identityCache.getWorldName(worldId).ifPresent(worldName -> target.put(id, ChunkPos.of(worldName, x, z)));
        }
        resultSet.close();
        return target;
    }

    private Table<Integer, Material, Integer> loadChunkMaterial() throws SQLException {
        HashBasedTable target = HashBasedTable.create();
        ResultSet resultSet = this.selectChunkMaterial.executeQuery();
        while (resultSet.next()) {
            int id = resultSet.getInt("id");
            int chunkId = resultSet.getInt("chunk_id");
            int materialId = resultSet.getInt("material_id");
            int count = resultSet.getInt("count");
            this.identityCache.setChunkMaterialId(chunkId, materialId, id);
            this.identityCache.getMaterial(materialId).ifPresent(arg_0 -> ChunkLoader.lambda$loadChunkMaterial$1((Table)target, chunkId, count, arg_0));
        }
        resultSet.close();
        return target;
    }

    private Table<Integer, EntityType, Integer> loadChunkSpawner() throws SQLException {
        HashBasedTable target = HashBasedTable.create();
        ResultSet resultSet = this.selectChunkSpawner.executeQuery();
        while (resultSet.next()) {
            int id = resultSet.getInt("id");
            int chunkId = resultSet.getInt("chunk_id");
            int spawnerId = resultSet.getInt("spawner_id");
            int count = resultSet.getInt("count");
            this.identityCache.setChunkSpawnerId(chunkId, spawnerId, id);
            this.identityCache.getSpawner(spawnerId).ifPresent(arg_0 -> ChunkLoader.lambda$loadChunkSpawner$2((Table)target, chunkId, count, arg_0));
        }
        resultSet.close();
        return target;
    }

    private Table<Integer, WorthType, Double> loadChunkWorth() throws SQLException {
        HashBasedTable target = HashBasedTable.create();
        ResultSet resultSet = this.selectChunkWorth.executeQuery();
        while (resultSet.next()) {
            int id = resultSet.getInt("id");
            int chunkId = resultSet.getInt("chunk_id");
            int worthId = resultSet.getInt("worth_id");
            double worth = resultSet.getDouble("worth");
            this.identityCache.setChunkWorthId(chunkId, worthId, id);
            this.identityCache.getWorthType(worthId).ifPresent(arg_0 -> ChunkLoader.lambda$loadChunkWorth$3((Table)target, chunkId, worth, arg_0));
        }
        resultSet.close();
        return target;
    }

    private static /* synthetic */ void lambda$loadChunkWorth$3(Table target, int chunkId, double worth, WorthType worthType) {
        target.put((Object)chunkId, (Object)worthType, (Object)worth);
    }

    private static /* synthetic */ void lambda$loadChunkSpawner$2(Table target, int chunkId, int count, EntityType spawner) {
        target.put((Object)chunkId, (Object)spawner, (Object)count);
    }

    private static /* synthetic */ void lambda$loadChunkMaterial$1(Table target, int chunkId, int count, Material material) {
        target.put((Object)chunkId, (Object)material, (Object)count);
    }
}

