/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.RecalculateReason;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.ButtonMessage;
import net.novucs.ftop.gui.GuiLayout;
import net.novucs.ftop.gui.element.GuiElement;
import net.novucs.ftop.gui.element.GuiElementType;
import net.novucs.ftop.gui.element.GuiFactionList;
import net.novucs.ftop.hook.VaultEconomyHook;
import net.novucs.ftop.shade.com.zaxxer.hikari.HikariConfig;
import net.novucs.ftop.util.GenericUtils;
import net.novucs.ftop.util.StringUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;

public class Settings {
    private static final int LATEST_VERSION = 7;
    private static final ImmutableList<String> WORTH_HOVER = ImmutableList.of((Object)"&e&l-- General --", (Object)"&dTotal Worth: &b{worth:total}", (Object)"&dBlock Worth: &b{worth:block}", (Object)"&dChest Worth: &b{worth:chest}", (Object)"&dSpawner Worth: &b{worth:spawner}", (Object)"&dPlayer Balances: &b{worth:player_balance}", (Object)"&dFaction Bank: &b{worth:faction_balance}", (Object)"", (Object)"&e&l-- Spawners --", (Object)"&dSlime: &b{count:spawner:slime}", (Object)"&dSkeleton: &b{count:spawner:skeleton}", (Object)"&dZombie: &b{count:spawner:zombie}", (Object[])new String[]{"", "&e&l-- Materials --", "&dEmerald Block: &b{count:material:emerald_block}", "&dDiamond Block: &b{count:material:diamond_block}", "&dGold Block: &b{count:material:gold_block}", "&dIron Block: &b{count:material:iron_block}", "&dCoal Block: &b{count:material:coal_block}"});
    private static final ImmutableList<ImmutableMap<?, ?>> GUI_LAYOUT = ImmutableList.of((Object)ImmutableMap.of((Object)"type", (Object)"button_back", (Object)"enabled", (Object)ImmutableMap.of((Object)"text", (Object)"&bBack", (Object)"lore", new ArrayList(), (Object)"material", (Object)"wool", (Object)"data", (Object)5), (Object)"disabled", (Object)ImmutableMap.of((Object)"text", (Object)"&7Back", (Object)"lore", new ArrayList(), (Object)"material", (Object)"wool", (Object)"data", (Object)14)), (Object)ImmutableMap.of((Object)"type", (Object)"faction_list", (Object)"faction-count", (Object)7, (Object)"fill-empty", (Object)true, (Object)"text", (Object)"&e{rank}. {relcolor}{faction} &b{worth:total}", (Object)"lore", new ArrayList<String>((Collection<String>)WORTH_HOVER)), (Object)ImmutableMap.of((Object)"type", (Object)"button_next", (Object)"enabled", (Object)ImmutableMap.of((Object)"text", (Object)"&bNext", (Object)"lore", new ArrayList(), (Object)"material", (Object)"wool", (Object)"data", (Object)5), (Object)"disabled", (Object)ImmutableMap.of((Object)"text", (Object)"&7Next", (Object)"lore", new ArrayList(), (Object)"material", (Object)"wool", (Object)"data", (Object)14)));
    private final FactionsTopPlugin plugin;
    private FileConfiguration config;
    private File configFile;
    private DecimalFormat countFormat;
    private DecimalFormat currencyFormat;
    private ButtonMessage backButtonMessage;
    private ButtonMessage nextButtonMessage;
    private String headerMessage;
    private String noEntriesMessage;
    private String bodyMessage;
    private List<String> bodyTooltip;
    private String footerMessage;
    private String permissionMessage;
    private String recalculationStartMessage;
    private String recalculationFinishMessage;
    private String recalculationStopMessage;
    private List<String> guiCommandAliases;
    private int guiLineCount;
    private String guiInventoryName;
    private GuiLayout guiLayout;
    private List<String> commandAliases;
    private List<String> ignoredFactionIds;
    private boolean disableChestEvents;
    private int factionsPerPage;
    private int signUpdateTicks;
    private int liquidUpdateTicks;
    private int chunkQueueSize;
    private int recalculateChunksPerTick;
    private long chunkRecalculateMillis;
    private boolean chatEnabled;
    private String chatRankPlaceholder;
    private String chatRankFound;
    private String chatRankNotFound;
    private String placeholdersFactionNotFound;
    private List<Integer> placeholdersEnabledRanks;
    private long databasePersistInterval;
    private boolean databasePersistFactions;
    private HikariConfig hikariConfig;
    private Map<WorthType, Boolean> enabled;
    private Map<RecalculateReason, Boolean> performRecalculate;
    private Map<RecalculateReason, Boolean> bypassRecalculateDelay;
    private Map<EntityType, Double> spawnerPrices;
    private Map<Material, Double> blockPrices;

    public Settings(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    public DecimalFormat getCountFormat() {
        return this.countFormat;
    }

    public DecimalFormat getCurrencyFormat() {
        return this.currencyFormat;
    }

    public ButtonMessage getBackButtonMessage() {
        return this.backButtonMessage;
    }

    public ButtonMessage getNextButtonMessage() {
        return this.nextButtonMessage;
    }

    public String getHeaderMessage() {
        return this.headerMessage;
    }

    public String getNoEntriesMessage() {
        return this.noEntriesMessage;
    }

    public String getBodyMessage() {
        return this.bodyMessage;
    }

    public List<String> getBodyTooltip() {
        return this.bodyTooltip;
    }

    public String getFooterMessage() {
        return this.footerMessage;
    }

    public String getPermissionMessage() {
        return this.permissionMessage;
    }

    public String getRecalculationStartMessage() {
        return this.recalculationStartMessage;
    }

    public String getRecalculationFinishMessage() {
        return this.recalculationFinishMessage;
    }

    public String getRecalculationStopMessage() {
        return this.recalculationStopMessage;
    }

    public List<String> getGuiCommandAliases() {
        return this.guiCommandAliases;
    }

    public int getGuiLineCount() {
        return this.guiLineCount;
    }

    public String getGuiInventoryName() {
        return this.guiInventoryName;
    }

    public GuiLayout getGuiLayout() {
        return this.guiLayout;
    }

    public List<String> getCommandAliases() {
        return this.commandAliases;
    }

    public List<String> getIgnoredFactionIds() {
        return this.ignoredFactionIds;
    }

    public boolean isDisableChestEvents() {
        return this.disableChestEvents;
    }

    public int getFactionsPerPage() {
        return this.factionsPerPage;
    }

    public int getSignUpdateTicks() {
        return this.signUpdateTicks;
    }

    public int getLiquidUpdateTicks() {
        return this.liquidUpdateTicks;
    }

    public int getChunkQueueSize() {
        return this.chunkQueueSize;
    }

    public int getRecalculateChunksPerTick() {
        return this.recalculateChunksPerTick;
    }

    public long getChunkRecalculateMillis() {
        return this.chunkRecalculateMillis;
    }

    public boolean isChatEnabled() {
        return this.chatEnabled;
    }

    public String getChatRankPlaceholder() {
        return this.chatRankPlaceholder;
    }

    public String getChatRankFound() {
        return this.chatRankFound;
    }

    public String getChatRankNotFound() {
        return this.chatRankNotFound;
    }

    public String getPlaceholdersFactionNotFound() {
        return this.placeholdersFactionNotFound;
    }

    public List<Integer> getPlaceholdersEnabledRanks() {
        return this.placeholdersEnabledRanks;
    }

    public long getDatabasePersistInterval() {
        return this.databasePersistInterval;
    }

    public boolean isDatabasePersistFactions() {
        return this.databasePersistFactions;
    }

    public HikariConfig getHikariConfig() {
        return this.hikariConfig;
    }

    public boolean isEnabled(WorthType worthType) {
        return this.enabled.getOrDefault((Object)worthType, false);
    }

    public boolean isPerformRecalculate(RecalculateReason reason) {
        return this.performRecalculate.getOrDefault((Object)reason, false);
    }

    public boolean isBypassRecalculateDelay(RecalculateReason reason) {
        return this.bypassRecalculateDelay.getOrDefault((Object)reason, false);
    }

    public double getSpawnerPrice(EntityType entityType) {
        return this.spawnerPrices.getOrDefault(entityType, 0.0);
    }

    public double getBlockPrice(Material material) {
        return this.blockPrices.getOrDefault(material, 0.0);
    }

    private void set(String path, Object val) {
        this.config.set(path, val);
    }

    private boolean getBoolean(String path, boolean def) {
        this.config.addDefault(path, (Object)def);
        return this.config.getBoolean(path);
    }

    private int getInt(String path, int def) {
        this.config.addDefault(path, (Object)def);
        return this.config.getInt(path);
    }

    private long getLong(String path, long def) {
        this.config.addDefault(path, (Object)def);
        return this.config.getLong(path);
    }

    private double getDouble(String path, double def) {
        this.config.addDefault(path, (Object)def);
        return this.config.getDouble(path);
    }

    private String getString(String path, String def) {
        this.config.addDefault(path, (Object)def);
        return this.config.getString(path);
    }

    private ConfigurationSection getOrCreateSection(String key) {
        return this.config.getConfigurationSection(key) == null ? this.config.createSection(key) : this.config.getConfigurationSection(key);
    }

    private ConfigurationSection getOrDefaultSection(String key) {
        return this.config.getConfigurationSection(key).getKeys(false).isEmpty() ? this.config.getDefaults().getConfigurationSection(key) : this.config.getConfigurationSection(key);
    }

    private <T> List<?> getList(String key, List<T> def) {
        this.config.addDefault(key, def);
        return this.config.getList(key, this.config.getList(key));
    }

    private <E> List<E> getList(String key, List<E> def, Class<E> type) {
        try {
            return this.castList(type, this.getList(key, def));
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    private <E> List<E> castList(Class<? extends E> type, List<?> toCast) throws ClassCastException {
        return toCast.stream().map(type::cast).collect(Collectors.toList());
    }

    private <T extends Enum<T>> EnumMap<T, Boolean> parseStateMap(Class<T> type, String key, boolean def) {
        EnumMap<T, Boolean> target = new EnumMap<T, Boolean>(type);
        ConfigurationSection section = this.getOrDefaultSection(key);
        for (String name : section.getKeys(false)) {
            Optional<T> parsed = GenericUtils.parseEnum(type, name);
            if (!parsed.isPresent()) {
                this.plugin.getLogger().warning("Invalid " + type.getSimpleName() + ": " + name);
                continue;
            }
            target.put((Enum)parsed.get(), section.getBoolean(name, def));
        }
        return target;
    }

    private <T extends Enum<T>> void addDefaults(Class<T> type, String key, boolean def, List<T> exempt) {
        ConfigurationSection section = this.getOrCreateSection(key);
        for (Enum target : (Enum[])type.getEnumConstants()) {
            section.addDefault(target.name().toLowerCase(), (Object)(exempt.contains(target) != def ? 1 : 0));
        }
    }

    private <T extends Enum<T>> EnumMap<T, Double> parsePriceMap(Class<T> type, String key, double def) {
        EnumMap<T, Double> target = new EnumMap<T, Double>(type);
        ConfigurationSection section = this.getOrDefaultSection(key);
        for (String name : section.getKeys(false)) {
            Optional<T> parsed = GenericUtils.parseEnum(type, name);
            if (!parsed.isPresent()) {
                this.plugin.getLogger().warning("Invalid " + type.getSimpleName() + ": " + name);
                continue;
            }
            target.put((Enum)parsed.get(), section.getDouble(name, def));
        }
        return target;
    }

    private <T extends Enum<T>> void addDefaults(String key, Map<T, Double> prices) {
        ConfigurationSection section = this.getOrCreateSection(key);
        prices.forEach((type, price) -> section.addDefault(type.name().toLowerCase(), price));
    }

    private <T extends Enum<T>> EnumMap<T, Double> parseDefPrices(Class<T> type, Map<String, Double> def) {
        EnumMap target = new EnumMap(type);
        def.forEach((name, price) -> GenericUtils.parseEnum(type, name).ifPresent(t -> target.put((Object)t, price)));
        return target;
    }

    private GuiLayout loadGuiLayout() {
        this.config.addDefault("gui-settings.layout", GUI_LAYOUT);
        List layout = this.config.getMapList("gui-settings.layout");
        ArrayList elements = new ArrayList(layout.size());
        for (Map element : layout) {
            GenericUtils.getEnum(GuiElementType.class, element, "type").ifPresent(guiElementType -> elements.add(guiElementType.getParser().parse(element)));
        }
        int factionsPerPage = 0;
        for (GuiElement element : elements) {
            if (!(element instanceof GuiFactionList)) continue;
            factionsPerPage += ((GuiFactionList)element).getFactionCount();
        }
        return new GuiLayout((ImmutableList<GuiElement>)ImmutableList.copyOf(elements), factionsPerPage);
    }

    private HikariConfig loadHikariConfig() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(this.getString("settings.database.jdbc-url", "jdbc:h2:./plugins/FactionsTop/database"));
        hikariConfig.setUsername(this.getString("settings.database.username", "root"));
        hikariConfig.setPassword(this.getString("settings.database.password", "pa$$w0rd"));
        hikariConfig.setMaximumPoolSize(this.getInt("settings.database.maximum-pool-size", 10));
        hikariConfig.setMaxLifetime(this.getLong("settings.database.max-lifetime", 5000L));
        hikariConfig.setIdleTimeout(this.getLong("settings.database.idle-timeout", 5000L));
        hikariConfig.setConnectionTimeout(this.getLong("settings.database.connection-timeout", 5000L));
        hikariConfig.setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("factions-top-sql-pool-%d").build());
        return hikariConfig;
    }

    private ButtonMessage getButtonMessage(String path, ButtonMessage def) {
        String enabled = StringUtils.format(this.getString(path + ".enabled", def.getEnabled()));
        String disabled = StringUtils.format(this.getString(path + ".disabled", def.getDisabled()));
        List<String> tooltip = StringUtils.format(this.getList(path + ".tooltip", def.getTooltip(), String.class));
        return new ButtonMessage(enabled, disabled, tooltip);
    }

    public void load() throws IOException, InvalidConfigurationException {
        this.configFile = new File(this.plugin.getDataFolder() + File.separator + "config.yml");
        this.configFile.getParentFile().mkdirs();
        this.configFile.createNewFile();
        this.config = new YamlConfiguration();
        this.config.load(this.configFile);
        int version = this.getInt("config-version", 0);
        this.countFormat = new DecimalFormat(this.getString("messages.count-format", "#,###"));
        this.currencyFormat = new DecimalFormat(this.getString("messages.currency-format", "$#,###.##"));
        this.backButtonMessage = this.getButtonMessage("messages.button-back", new ButtonMessage("&b[<]", "&7[<]", Collections.singletonList("&dCommand: &b/f top {page:back}")));
        this.nextButtonMessage = this.getButtonMessage("messages.button-next", new ButtonMessage("&b[>]", "&7[>]", Collections.singletonList("&dCommand: &b/f top {page:next}")));
        this.headerMessage = StringUtils.format(this.getString("messages.header", "&6_______.[ &2Top Factions {button:back} &6{page:this}/{page:last} {button:next} &6]._______"));
        this.noEntriesMessage = StringUtils.format(this.getString("messages.no-entries", "&eNo entries to be displayed."));
        this.bodyMessage = StringUtils.format(this.getString("messages.body.text", "&e{rank}. {relcolor}{faction} &b{worth:total}"));
        this.bodyTooltip = StringUtils.format(this.getList("messages.body.tooltip", new ArrayList<String>((Collection<String>)WORTH_HOVER), String.class));
        this.footerMessage = StringUtils.format(this.getString("messages.footer", ""));
        this.permissionMessage = StringUtils.format(this.getString("messages.permission", "&cYou do not have permission."));
        this.recalculationStartMessage = StringUtils.format(this.getString("messages.recalculation-start", "&eAll faction totals are being resynchronized"));
        this.recalculationFinishMessage = StringUtils.format(this.getString("messages.recalculation-finish", "&eResynchronization of faction totals complete"));
        this.recalculationStopMessage = StringUtils.format(this.getString("messages.recalculation-stop", "&eResynchronization of faction totals stopped"));
        this.guiCommandAliases = this.getList("gui-settings.command-aliases", Collections.singletonList("f topgui"), String.class);
        this.guiLineCount = this.getInt("gui-settings.line-count", 1);
        this.guiInventoryName = StringUtils.format(this.getString("gui-settings.inventory-name", "&lTop Factions | Page {page:this}"));
        this.guiLayout = this.loadGuiLayout();
        this.commandAliases = this.getList("settings.command-aliases", Collections.singletonList("f top"), String.class);
        this.ignoredFactionIds = this.getList("settings.ignored-faction-ids", Arrays.asList("none", "safezone", "warzone", "0", "-1", "-2"), String.class);
        this.disableChestEvents = this.getBoolean("settings.disable-chest-events", false);
        this.factionsPerPage = this.getInt("settings.factions-per-page", 9);
        this.signUpdateTicks = this.getInt("settings.sign-update-ticks", 1);
        this.liquidUpdateTicks = this.getInt("settings.liquid-update-ticks", 100);
        if (this.plugin.getEconomyHook() instanceof VaultEconomyHook) {
            ((VaultEconomyHook)this.plugin.getEconomyHook()).setLiquidUpdateTicks(this.liquidUpdateTicks);
        }
        this.chunkQueueSize = this.getInt("settings.chunk-queue-size", 200);
        this.recalculateChunksPerTick = this.getInt("settings.recalculate-chunks-per-tick", 50);
        this.chunkRecalculateMillis = this.getLong("settings.chunk-recalculate-millis", 120000L);
        this.chatEnabled = this.getBoolean("settings.chat.enabled", false);
        this.chatRankPlaceholder = this.getString("settings.chat.rank-placeholder", "{factions_top_rank}");
        this.chatRankFound = StringUtils.format(this.getString("settings.chat.rank-found", "&2[&e#{rank}&2]"));
        this.chatRankNotFound = StringUtils.format(this.getString("settings.chat.rank-not-found", ""));
        this.placeholdersFactionNotFound = StringUtils.format(this.getString("settings.placeholders.faction-not-found", "-"));
        this.placeholdersEnabledRanks = this.getList("settings.placeholders.enabled-ranks", Arrays.asList(1, 2, 3), Integer.class);
        if (this.hikariConfig == null) {
            this.hikariConfig = this.loadHikariConfig();
        }
        this.databasePersistInterval = Math.max(1000L, this.getLong("settings.database.persist-interval", 60000L));
        this.databasePersistFactions = this.getBoolean("settings.database.persist-factions", false);
        this.addDefaults(WorthType.class, "settings.enabled", true, Collections.emptyList());
        this.enabled = this.parseStateMap(WorthType.class, "settings.enabled", false);
        if (this.plugin.getEconomyHook() != null) {
            this.plugin.getEconomyHook().setFactionEnabled(this.isEnabled(WorthType.FACTION_BALANCE));
            this.plugin.getEconomyHook().setPlayerEnabled(this.isEnabled(WorthType.PLAYER_BALANCE));
        }
        this.addDefaults(RecalculateReason.class, "settings.perform-recalculate", true, Collections.emptyList());
        this.performRecalculate = this.parseStateMap(RecalculateReason.class, "settings.perform-recalculate", false);
        this.addDefaults(RecalculateReason.class, "settings.bypass-recalculate-delay", false, Arrays.asList(RecalculateReason.COMMAND, RecalculateReason.UNLOAD, RecalculateReason.CLAIM));
        this.bypassRecalculateDelay = this.parseStateMap(RecalculateReason.class, "settings.bypass-recalculate-delay", false);
        ImmutableMap prices = ImmutableMap.of((Object)"SLIME", (Object)75000.0, (Object)"SKELETON", (Object)30000.0, (Object)"ZOMBIE", (Object)25000.0);
        this.addDefaults("settings.spawner-prices", this.parseDefPrices(EntityType.class, (Map<String, Double>)prices));
        this.spawnerPrices = this.parsePriceMap(EntityType.class, "settings.spawner-prices", 0.0);
        prices = ImmutableMap.of((Object)"EMERALD_BLOCK", (Object)1250.0, (Object)"DIAMOND_BLOCK", (Object)1000.0, (Object)"GOLD_BLOCK", (Object)250.0, (Object)"IRON_BLOCK", (Object)75.0, (Object)"COAL_BLOCK", (Object)25.0);
        this.addDefaults("settings.block-prices", this.parseDefPrices(Material.class, (Map<String, Double>)prices));
        this.blockPrices = this.parsePriceMap(Material.class, "settings.block-prices", 0.0);
        if (version < 7) {
            this.config.options().header(this.getDocumentation());
            this.config.options().copyDefaults(true);
            this.set("config-version", 7);
            this.config.save(this.configFile);
            this.plugin.getLogger().info("Configuration file has been successfully updated.");
        }
    }

    public String getDocumentation() {
        Scanner scanner = new Scanner(this.plugin.getResource("readme.txt")).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }
}

