/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.task;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.BlockPos;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.entity.ChunkWorth;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.entity.IdentityCache;
import net.novucs.ftop.manager.DatabaseManager;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class PersistenceTask
extends Thread {
    private final FactionsTopPlugin plugin;
    private final Map<ChunkPos, ChunkWorth> worthCache = new HashMap<ChunkPos, ChunkWorth>();
    private final BlockingQueue<Map.Entry<ChunkPos, ChunkWorth>> chunkQueue = new LinkedBlockingQueue<Map.Entry<ChunkPos, ChunkWorth>>();
    private final BlockingQueue<FactionWorth> factionQueue = new LinkedBlockingQueue<FactionWorth>();
    private final BlockingQueue<String> factionDeletionQueue = new LinkedBlockingQueue<String>();
    private final BlockingQueue<Map.Entry<BlockPos, Integer>> signCreationQueue = new LinkedBlockingQueue<Map.Entry<BlockPos, Integer>>();
    private final BlockingQueue<BlockPos> signDeletionQueue = new LinkedBlockingQueue<BlockPos>();

    public void queue(ChunkPos pos, ChunkWorth chunkWorth) {
        ChunkWorth cachedWorth = this.worthCache.get(pos);
        if (cachedWorth == null || !this.chunkWorthEquals(chunkWorth, cachedWorth)) {
            this.chunkQueue.add(new AbstractMap.SimpleImmutableEntry<ChunkPos, ChunkWorth>(pos, chunkWorth));
            this.worthCache.put(pos, this.clone(chunkWorth));
        }
    }

    public void queue(FactionWorth factionWorth) {
        if (this.plugin.getSettings().isDatabasePersistFactions()) {
            this.factionQueue.add(factionWorth);
        }
    }

    public void queue(Collection<FactionWorth> factions) {
        if (this.plugin.getSettings().isDatabasePersistFactions()) {
            this.factionQueue.addAll(factions);
        }
    }

    public void queueDeletedFaction(String factionId) {
        if (this.plugin.getSettings().isDatabasePersistFactions()) {
            this.factionDeletionQueue.add(factionId);
        }
    }

    public void queueCreatedSign(BlockPos block, int rank) {
        this.signCreationQueue.add(new AbstractMap.SimpleImmutableEntry<BlockPos, Integer>(block, rank));
    }

    public void queueDeletedSign(BlockPos block) {
        this.signDeletionQueue.add(block);
    }

    public PersistenceTask(FactionsTopPlugin plugin) {
        super("factions-top-persistence-task");
        this.plugin = plugin;
    }

    @Override
    public void start() {
        this.loadChunkCache();
        super.start();
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            if (this.plugin.getSettings().isDatabasePersistFactions()) {
                this.deleteInvalidFactions();
            }
            this.persist();
            try {
                PersistenceTask.sleep(this.plugin.getSettings().getDatabasePersistInterval());
            }
            catch (InterruptedException e) {
                this.interrupt();
                break;
            }
        }
        this.persist();
    }

    private void deleteInvalidFactions() {
        Set<String> factionIds = this.plugin.getFactionsHook().getFactionIds();
        for (String factionId : this.plugin.getDatabaseManager().getIdentityCache().getFactionIds()) {
            if (factionIds.contains(factionId)) continue;
            this.factionDeletionQueue.add(factionId);
        }
    }

    private void persist() {
        HashSet<Map.Entry<ChunkPos, ChunkWorth>> chunks = new HashSet<Map.Entry<ChunkPos, ChunkWorth>>();
        this.chunkQueue.drainTo(chunks);
        HashSet<FactionWorth> factions = new HashSet<FactionWorth>();
        this.factionQueue.drainTo(factions);
        HashSet<String> deletedFactions = new HashSet<String>();
        this.factionDeletionQueue.drainTo(deletedFactions);
        HashSet<Map.Entry<BlockPos, Integer>> createdSigns = new HashSet<Map.Entry<BlockPos, Integer>>();
        this.signCreationQueue.drainTo(createdSigns);
        HashSet<BlockPos> deletedSigns = new HashSet<BlockPos>();
        this.signDeletionQueue.drainTo(deletedSigns);
        try {
            this.plugin.getDatabaseManager().save(chunks, factions, deletedFactions, createdSigns, deletedSigns);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to persist queued updates to the database");
            this.plugin.getLogger().log(Level.SEVERE, "Are the database credentials in the config correct?");
            this.plugin.getLogger().log(Level.SEVERE, "Stack trace: ", e);
            this.plugin.getLogger().log(Level.INFO, "Attempting to regenerate HikariCP datasource...");
            try {
                IdentityCache identityCache = this.plugin.getDatabaseManager().getIdentityCache();
                this.plugin.getDatabaseManager().close();
                this.plugin.setDatabaseManager(DatabaseManager.create(this.plugin.getSettings().getHikariConfig(), identityCache));
                this.plugin.getLogger().log(Level.SEVERE, "Regeneration successful, issue is with HikariCP datasource");
            }
            catch (SQLException ignore) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to regenerate, issue not with HikariCP datasource");
            }
        }
    }

    private void loadChunkCache() {
        this.plugin.getWorthManager().getChunks().forEach((chunkPos, chunkWorth) -> this.worthCache.put((ChunkPos)chunkPos, this.clone((ChunkWorth)chunkWorth)));
    }

    private ChunkWorth clone(ChunkWorth chunkWorth) {
        EnumMap<WorthType, Double> worth = new EnumMap<WorthType, Double>(WorthType.class);
        worth.putAll(chunkWorth.getWorth());
        EnumMap<Material, Integer> materials = new EnumMap<Material, Integer>(Material.class);
        materials.putAll(chunkWorth.getMaterials());
        EnumMap<EntityType, Integer> spawners = new EnumMap<EntityType, Integer>(EntityType.class);
        spawners.putAll(chunkWorth.getSpawners());
        return new ChunkWorth(worth, materials, spawners);
    }

    private boolean chunkWorthEquals(ChunkWorth chunkWorth1, ChunkWorth chunkWorth2) {
        return Objects.equals(chunkWorth1.getWorth(), chunkWorth2.getWorth()) && Objects.equals(chunkWorth1.getMaterials(), chunkWorth2.getMaterials()) && Objects.equals(chunkWorth1.getSpawners(), chunkWorth2.getSpawners());
    }
}

