/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.task;

import java.util.EnumMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.ChunkPos;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public class ChunkWorthTask
extends Thread {
    private final FactionsTopPlugin plugin;
    private final BlockingQueue<ChunkSnapshot> queue = new LinkedBlockingQueue<ChunkSnapshot>();

    public ChunkWorthTask(FactionsTopPlugin plugin) {
        super("factions-top-chunk-task");
        this.plugin = plugin;
    }

    public void queue(ChunkSnapshot snapshot) {
        this.queue.add(snapshot);
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            ChunkSnapshot snapshot;
            try {
                snapshot = this.queue.take();
            }
            catch (InterruptedException e) {
                this.interrupt();
                break;
            }
            ChunkPos pos = ChunkPos.of(snapshot);
            double worth = 0.0;
            EnumMap<Material, Integer> materials = new EnumMap<Material, Integer>(Material.class);
            for (int y = 0; y < 256; ++y) {
                if (snapshot.isSectionEmpty(y >> 4)) {
                    y += 15;
                    continue;
                }
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        Material material = Material.getMaterial((int)snapshot.getBlockTypeId(x, y, z));
                        if (material == null) continue;
                        double blockPrice = this.plugin.getSettings().getBlockPrice(material);
                        worth += blockPrice;
                        if (blockPrice == 0.0) continue;
                        int count = materials.getOrDefault(material, 0);
                        materials.put(material, count + 1);
                    }
                }
            }
            double worthFinal = worth;
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                this.plugin.getWorthManager().set(pos, WorthType.BLOCK, worthFinal);
                this.plugin.getWorthManager().setMaterials(pos, materials);
            });
        }
    }
}

