/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.shade.com.zaxxer.hikari.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.novucs.ftop.shade.com.zaxxer.hikari.util.FastList;
import net.novucs.ftop.shade.com.zaxxer.hikari.util.QueuedSequenceSynchronizer;
import net.novucs.ftop.shade.org.slf4j.Logger;
import net.novucs.ftop.shade.org.slf4j.LoggerFactory;

public class ConcurrentBag<T extends IConcurrentBagEntry>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentBag.class);
    private final QueuedSequenceSynchronizer synchronizer;
    private final CopyOnWriteArrayList<T> sharedList;
    private final boolean weakThreadLocals;
    private final ThreadLocal<List<Object>> threadList;
    private final IBagStateListener listener;
    private final AtomicInteger waiters;
    private volatile boolean closed;

    public ConcurrentBag(IBagStateListener listener) {
        this.listener = listener;
        this.weakThreadLocals = this.useWeakThreadLocals();
        this.waiters = new AtomicInteger();
        this.sharedList = new CopyOnWriteArrayList();
        this.synchronizer = new QueuedSequenceSynchronizer();
        this.threadList = this.weakThreadLocals ? new ThreadLocal() : new ThreadLocal<List<Object>>(){

            @Override
            protected List<Object> initialValue() {
                return new FastList<Object>(IConcurrentBagEntry.class, 16);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
        List<Object> list = this.threadList.get();
        if (this.weakThreadLocals && list == null) {
            list = new ArrayList<Object>(16);
            this.threadList.set(list);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            IConcurrentBagEntry bagEntry;
            Object entry = list.remove(i);
            IConcurrentBagEntry iConcurrentBagEntry = bagEntry = this.weakThreadLocals ? (IConcurrentBagEntry)((WeakReference)entry).get() : (IConcurrentBagEntry)entry;
            if (bagEntry == null || !bagEntry.compareAndSet(0, 1)) continue;
            return (T)bagEntry;
        }
        timeout = timeUnit.toNanos(timeout);
        Future<Boolean> addItemFuture = null;
        long startScan = System.nanoTime();
        long originTimeout = timeout;
        this.waiters.incrementAndGet();
        try {
            while (true) {
                long startSeq = this.synchronizer.currentSequence();
                for (IConcurrentBagEntry bagEntry : this.sharedList) {
                    if (!bagEntry.compareAndSet(0, 1)) continue;
                    if (this.waiters.get() > 1 && addItemFuture == null) {
                        this.listener.addBagItem();
                    }
                    IConcurrentBagEntry iConcurrentBagEntry = bagEntry;
                    return (T)iConcurrentBagEntry;
                }
                if (startSeq < this.synchronizer.currentSequence()) continue;
                if (addItemFuture == null || addItemFuture.isDone()) {
                    addItemFuture = this.listener.addBagItem();
                }
                if ((timeout = originTimeout - (System.nanoTime() - startScan)) <= 10000L || !this.synchronizer.waitUntilSequenceExceeded(startSeq, timeout)) break;
            }
        }
        finally {
            this.waiters.decrementAndGet();
        }
        return null;
    }

    public void requite(T bagEntry) {
        bagEntry.lazySet(0);
        List<Object> threadLocalList = this.threadList.get();
        if (threadLocalList != null) {
            threadLocalList.add(this.weakThreadLocals ? new WeakReference<T>(bagEntry) : bagEntry);
        }
        this.synchronizer.signal();
    }

    public void add(T bagEntry) {
        if (this.closed) {
            LOGGER.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.sharedList.add(bagEntry);
        this.synchronizer.signal();
    }

    public boolean remove(T bagEntry) {
        if (!(bagEntry.compareAndSet(1, -1) || bagEntry.compareAndSet(-2, -1) || this.closed)) {
            LOGGER.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", (Object)bagEntry);
            return false;
        }
        boolean removed = this.sharedList.remove(bagEntry);
        if (!removed && !this.closed) {
            LOGGER.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)bagEntry);
        }
        return removed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public List<T> values(int state) {
        ArrayList<IConcurrentBagEntry> list = new ArrayList<IConcurrentBagEntry>(this.sharedList.size());
        for (IConcurrentBagEntry entry : this.sharedList) {
            if (entry.getState() != state) continue;
            list.add(entry);
        }
        return list;
    }

    public List<T> values() {
        return (List)this.sharedList.clone();
    }

    public boolean reserve(T bagEntry) {
        return bagEntry.compareAndSet(0, -2);
    }

    public void unreserve(T bagEntry) {
        if (bagEntry.compareAndSet(-2, 0)) {
            this.synchronizer.signal();
        } else {
            LOGGER.warn("Attempt to relinquish an object to the bag that was not reserved: {}", (Object)bagEntry);
        }
    }

    public int getPendingQueue() {
        return this.synchronizer.getQueueLength();
    }

    public int getCount(int state) {
        int count = 0;
        for (IConcurrentBagEntry entry : this.sharedList) {
            if (entry.getState() != state) continue;
            ++count;
        }
        return count;
    }

    public int size() {
        return this.sharedList.size();
    }

    public void dumpState() {
        for (IConcurrentBagEntry bagEntry : this.sharedList) {
            LOGGER.info(bagEntry.toString());
        }
    }

    private boolean useWeakThreadLocals() {
        try {
            if (System.getProperty("net.novucs.ftop.shade.com.zaxxer.hikari.useWeakReferences") != null) {
                return Boolean.getBoolean("net.novucs.ftop.shade.com.zaxxer.hikari.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException se) {
            return true;
        }
    }

    public static interface IBagStateListener {
        public Future<Boolean> addBagItem();
    }

    public static interface IConcurrentBagEntry {
        public static final int STATE_NOT_IN_USE = 0;
        public static final int STATE_IN_USE = 1;
        public static final int STATE_REMOVED = -1;
        public static final int STATE_RESERVED = -2;

        public boolean compareAndSet(int var1, int var2);

        public void lazySet(int var1);

        public int getState();
    }
}

