/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.shade.com.zaxxer.hikari.metrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import net.novucs.ftop.shade.com.zaxxer.hikari.metrics.MetricsTracker;
import net.novucs.ftop.shade.com.zaxxer.hikari.metrics.PoolStats;

public final class CodaHaleMetricsTracker
extends MetricsTracker {
    private final String poolName;
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;
    private final Meter connectionTimeoutMeter;
    private final MetricRegistry registry;

    public CodaHaleMetricsTracker(String poolName, final PoolStats poolStats, MetricRegistry registry) {
        this.poolName = poolName;
        this.registry = registry;
        this.connectionObtainTimer = registry.timer(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "Wait"}));
        this.connectionUsage = registry.histogram(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "Usage"}));
        this.connectionTimeoutMeter = registry.meter(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "ConnectionTimeoutRate"}));
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "TotalConnections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return poolStats.getTotalConnections();
            }
        });
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "IdleConnections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return poolStats.getIdleConnections();
            }
        });
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "ActiveConnections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return poolStats.getActiveConnections();
            }
        });
        registry.register(MetricRegistry.name((String)poolName, (String[])new String[]{"pool", "PendingConnections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return poolStats.getPendingThreads();
            }
        });
    }

    @Override
    public void close() {
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "Wait"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "Usage"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "TotalConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "IdleConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "ActiveConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "PendingConnections"}));
    }

    @Override
    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.connectionObtainTimer.update(elapsedAcquiredNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.connectionUsage.update(elapsedBorrowedMillis);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutMeter.mark();
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }
}

