/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.manager;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.RecalculateReason;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.entity.ChunkWorth;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.util.SplaySet;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class WorthManager
implements PluginService {
    private final FactionsTopPlugin plugin;
    private final Map<ChunkPos, ChunkWorth> chunks = new HashMap<ChunkPos, ChunkWorth>();
    private final Map<String, FactionWorth> factions = new HashMap<String, FactionWorth>();
    private final SplaySet<FactionWorth> orderedFactions = SplaySet.create();
    private final Table<ChunkPos, WorthType, Double> recalculateQueue = HashBasedTable.create();
    private final Table<ChunkPos, Material, Integer> materialsQueue = HashBasedTable.create();

    public WorthManager(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    public SplaySet<FactionWorth> getOrderedFactions() {
        return this.orderedFactions;
    }

    public Set<String> getFactionIds() {
        return Collections.unmodifiableSet(this.factions.keySet());
    }

    public FactionWorth getWorth(String factionId) {
        return this.factions.get(factionId);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void terminate() {
    }

    public Map<ChunkPos, ChunkWorth> getChunks() {
        return this.chunks;
    }

    public void loadChunks(Map<ChunkPos, ChunkWorth> chunks) {
        this.chunks.clear();
        this.chunks.putAll(chunks);
    }

    public void updateAllFactions() {
        this.factions.clear();
        for (Map.Entry<ChunkPos, ChunkWorth> chunk : this.chunks.entrySet()) {
            FactionWorth worth = this.getFactionWorth(chunk.getKey());
            if (worth == null) continue;
            worth.addAll(chunk.getValue());
        }
        if (this.plugin.getSettings().isEnabled(WorthType.PLAYER_BALANCE)) {
            for (FactionWorth faction : this.factions.values()) {
                List<UUID> members = this.plugin.getFactionsHook().getMembers(faction.getFactionId());
                double balance = this.plugin.getEconomyHook().getTotalBalance(members);
                faction.addWorth(WorthType.PLAYER_BALANCE, balance);
            }
        }
        if (this.plugin.getSettings().isEnabled(WorthType.FACTION_BALANCE)) {
            for (FactionWorth faction : this.factions.values()) {
                double balance = this.plugin.getEconomyHook().getFactionBalance(faction.getFactionId());
                faction.addWorth(WorthType.FACTION_BALANCE, balance);
            }
        }
        this.orderedFactions.clear();
        for (FactionWorth worth : this.factions.values()) {
            this.orderedFactions.add(worth);
            this.plugin.getPersistenceTask().queue(worth);
        }
    }

    private ChunkWorth getChunkWorth(ChunkPos pos) {
        return this.chunks.compute(pos, (k, v) -> {
            if (v == null) {
                v = new ChunkWorth();
            }
            return v;
        });
    }

    private FactionWorth getFactionWorth(ChunkPos pos) {
        return this.getFactionWorth(this.plugin.getFactionsHook().getFactionAt(pos));
    }

    private FactionWorth getFactionWorth(String factionId) {
        if (this.plugin.getSettings().getIgnoredFactionIds().contains(factionId)) {
            return null;
        }
        return this.factions.compute(factionId, (k, v) -> {
            if (v == null) {
                v = new FactionWorth((String)k, this.plugin.getFactionsHook().getFactionName((String)k));
                this.orderedFactions.add((FactionWorth)v);
            }
            return v;
        });
    }

    public void set(ChunkPos pos, WorthType worthType, double worth) {
        FactionWorth factionWorth = this.getFactionWorth(pos);
        if (factionWorth == null) {
            return;
        }
        this.orderedFactions.remove(factionWorth);
        ChunkWorth chunkWorth = this.getChunkWorth(pos);
        double oldWorth = chunkWorth.getWorth(worthType);
        chunkWorth.setWorth(worthType, worth);
        factionWorth.addWorth(worthType, worth - oldWorth);
        if (this.recalculateQueue.contains((Object)pos, (Object)worthType)) {
            double queuedWorth = (Double)this.recalculateQueue.remove((Object)pos, (Object)worthType);
            chunkWorth.addWorth(worthType, queuedWorth);
            factionWorth.addWorth(worthType, queuedWorth);
            chunkWorth.setNextRecalculation(this.plugin.getSettings().getChunkRecalculateMillis() + System.currentTimeMillis());
        }
        this.orderedFactions.add(factionWorth);
    }

    public void setMaterials(ChunkPos pos, Map<Material, Integer> materials) {
        FactionWorth factionWorth = this.getFactionWorth(pos);
        if (factionWorth == null) {
            return;
        }
        ChunkWorth chunkWorth = this.getChunkWorth(pos);
        factionWorth.removeMaterials(chunkWorth.getMaterials());
        chunkWorth.setMaterials(materials);
        factionWorth.addMaterials(materials);
        if (this.materialsQueue.containsRow((Object)pos)) {
            Map queued = this.materialsQueue.row((Object)pos);
            chunkWorth.addMaterials(queued);
            factionWorth.addMaterials(queued);
            queued.clear();
        }
        this.plugin.getPersistenceTask().queue(pos, chunkWorth);
        this.plugin.getPersistenceTask().queue(factionWorth);
    }

    private void setSpawners(ChunkPos pos, Map<EntityType, Integer> spawners) {
        FactionWorth factionWorth = this.getFactionWorth(pos);
        if (factionWorth == null) {
            return;
        }
        ChunkWorth chunkWorth = this.getChunkWorth(pos);
        factionWorth.removeSpawners(chunkWorth.getSpawners());
        chunkWorth.setSpawners(spawners);
        factionWorth.addSpawners(spawners);
    }

    public void add(Chunk chunk, RecalculateReason reason, WorthType worthType, double worth, Map<Material, Integer> materials, Map<EntityType, Integer> spawners) {
        if (!this.plugin.getSettings().isEnabled(worthType) || worth == 0.0) {
            return;
        }
        ChunkPos pos = ChunkPos.of(chunk);
        FactionWorth factionWorth = this.getFactionWorth(pos);
        if (factionWorth == null) {
            return;
        }
        this.orderedFactions.remove(factionWorth);
        ChunkWorth chunkWorth = this.getChunkWorth(pos);
        chunkWorth.addWorth(worthType, worth);
        chunkWorth.addMaterials(materials);
        chunkWorth.addSpawners(spawners);
        factionWorth.addWorth(worthType, worth);
        factionWorth.addMaterials(materials);
        factionWorth.addSpawners(spawners);
        this.orderedFactions.add(factionWorth);
        if (this.materialsQueue.containsRow((Object)pos)) {
            this.materialsQueue.row((Object)pos).putAll(materials);
        }
        if (this.recalculateQueue.contains((Object)pos, (Object)worthType)) {
            double prev = (Double)this.recalculateQueue.get((Object)pos, (Object)worthType);
            this.recalculateQueue.put((Object)pos, (Object)worthType, (Object)(worth + prev));
            return;
        }
        this.recalculate(chunkWorth, pos, chunk, reason);
    }

    public void recalculate(Chunk chunk, RecalculateReason reason) {
        ChunkPos pos = ChunkPos.of(chunk);
        if (this.getFactionWorth(pos) == null) {
            return;
        }
        ChunkWorth chunkWorth = this.getChunkWorth(pos);
        this.recalculate(chunkWorth, pos, chunk, reason);
    }

    private void recalculate(ChunkWorth chunkWorth, ChunkPos pos, Chunk chunk, RecalculateReason reason) {
        if (chunkWorth.getNextRecalculation() >= System.currentTimeMillis() && !this.plugin.getSettings().isBypassRecalculateDelay(reason) || !this.plugin.getSettings().isPerformRecalculate(reason) || this.plugin.getSettings().getChunkQueueSize() <= this.plugin.getChunkWorthTask().getQueueSize()) {
            FactionWorth factionWorth = this.getFactionWorth(pos);
            if (factionWorth != null) {
                this.plugin.getPersistenceTask().queue(pos, chunkWorth);
                this.plugin.getPersistenceTask().queue(factionWorth);
            }
            return;
        }
        chunkWorth.setNextRecalculation(Long.MAX_VALUE);
        if (reason == RecalculateReason.UNLOAD) {
            this.forceRecalculate(pos, chunk);
        } else {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.forceRecalculate(pos, chunk));
        }
    }

    private void forceRecalculate(ChunkPos pos, Chunk chunk) {
        this.recalculateQueue.row((Object)pos).clear();
        EnumMap<EntityType, Integer> spawners = new EnumMap<EntityType, Integer>(EntityType.class);
        EnumMap<Material, Integer> materials = new EnumMap<Material, Integer>(Material.class);
        if (this.plugin.getSettings().isEnabled(WorthType.SPAWNER)) {
            this.set(pos, WorthType.SPAWNER, this.getSpawnerWorth(chunk, spawners));
        }
        if (this.plugin.getSettings().isEnabled(WorthType.CHEST)) {
            this.set(pos, WorthType.CHEST, this.getChestWorth(chunk, materials, spawners));
        }
        this.setSpawners(pos, spawners);
        this.materialsQueue.row((Object)pos).putAll(materials);
        this.plugin.getChunkWorthTask().queue(chunk.getChunkSnapshot());
    }

    private double getSpawnerWorth(Chunk chunk, Map<EntityType, Integer> spawners) {
        double worth = 0.0;
        for (BlockState blockState : chunk.getTileEntities()) {
            if (!(blockState instanceof CreatureSpawner)) continue;
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            EntityType spawnType = spawner.getSpawnedType();
            int stackSize = this.plugin.getSpawnerStackerHook().getStackSize(spawner);
            double blockPrice = this.plugin.getSettings().getSpawnerPrice(spawnType) * (double)stackSize;
            worth += blockPrice;
            if (blockPrice == 0.0) continue;
            int count = spawners.getOrDefault(spawnType, 0);
            spawners.put(spawnType, count + stackSize);
        }
        return worth;
    }

    private double getChestWorth(Chunk chunk, Map<Material, Integer> materials, Map<EntityType, Integer> spawners) {
        double worth = 0.0;
        for (BlockState blockState : chunk.getTileEntities()) {
            if (!(blockState instanceof Chest)) continue;
            Chest chest = (Chest)blockState;
            for (ItemStack item : chest.getBlockInventory()) {
                int count;
                double materialPrice;
                EntityType spawnerType;
                if (item == null) continue;
                int stackSize = item.getAmount();
                switch (item.getType()) {
                    case MOB_SPAWNER: {
                        spawnerType = this.plugin.getSpawnerStackerHook().getSpawnedType(item);
                        double price = this.plugin.getSettings().getSpawnerPrice(spawnerType);
                        materialPrice = price * (double)(stackSize *= this.plugin.getSpawnerStackerHook().getStackSize(item));
                        break;
                    }
                    default: {
                        materialPrice = this.plugin.getSettings().getBlockPrice(item.getType()) * (double)stackSize;
                        spawnerType = null;
                    }
                }
                worth += materialPrice;
                if (materialPrice == 0.0) continue;
                if (spawnerType == null) {
                    count = materials.getOrDefault(item.getType(), 0);
                    materials.put(item.getType(), count + stackSize);
                    continue;
                }
                count = spawners.getOrDefault(spawnerType, 0);
                spawners.put(spawnerType, count + stackSize);
            }
        }
        return worth;
    }

    public void update(String factionId, Collection<ChunkPos> claims, boolean unclaimed) {
        FactionWorth factionWorth = this.getFactionWorth(factionId);
        if (factionWorth == null) {
            return;
        }
        this.orderedFactions.remove(factionWorth);
        for (ChunkPos pos : claims) {
            Chunk chunk = pos.getChunk(this.plugin.getServer());
            if (chunk == null) continue;
            ChunkWorth chunkWorth = this.getChunkWorth(pos);
            for (WorthType worthType : WorthType.getPlaced()) {
                double worth = chunkWorth.getWorth(worthType);
                factionWorth.addWorth(worthType, unclaimed ? -worth : worth);
            }
            if (unclaimed) {
                factionWorth.removeMaterials(chunkWorth.getMaterials());
                factionWorth.removeSpawners(chunkWorth.getSpawners());
            } else {
                factionWorth.addMaterials(chunkWorth.getMaterials());
                factionWorth.addSpawners(chunkWorth.getSpawners());
            }
            this.recalculate(chunkWorth, pos, chunk, RecalculateReason.CLAIM);
        }
        this.orderedFactions.add(factionWorth);
    }

    public void add(String factionId, WorthType worthType, double worth) {
        if (WorthType.isPlaced(worthType) || !this.plugin.getSettings().isEnabled(worthType) || worth == 0.0) {
            return;
        }
        FactionWorth factionWorth = this.getFactionWorth(factionId);
        if (factionWorth == null) {
            return;
        }
        this.orderedFactions.remove(factionWorth);
        factionWorth.addWorth(worthType, worth);
        this.orderedFactions.add(factionWorth);
        this.plugin.getPersistenceTask().queue(factionWorth);
    }

    public void rename(String factionId, String newName) {
        FactionWorth factionWorth = this.factions.getOrDefault(factionId, null);
        if (factionWorth != null) {
            factionWorth.setName(newName);
            this.plugin.getPersistenceTask().queue(factionWorth);
        }
    }

    public void remove(String factionId) {
        FactionWorth factionWorth = this.factions.remove(factionId);
        this.orderedFactions.remove(factionWorth);
        this.plugin.getPersistenceTask().queueDeletedFaction(factionId);
    }
}

