/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.gui.GuiContext;
import net.novucs.ftop.util.SplaySet;
import net.novucs.ftop.util.StringUtils;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GuiManager {
    private static final int MAX_TITLE_SIZE = 32;
    private final FactionsTopPlugin plugin;
    private final Map<Inventory, GuiContext> inventories = new WeakHashMap<Inventory, GuiContext>();

    public GuiManager(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    public GuiContext getContext(Inventory inventory) {
        return this.inventories.get(inventory);
    }

    public void unloadGui(Inventory inventory) {
        this.inventories.remove(inventory);
    }

    public void closeInventories() {
        for (Inventory inventory : this.inventories.keySet()) {
            new ArrayList<HumanEntity>(inventory.getViewers()).forEach(HumanEntity::closeInventory);
        }
    }

    public void sendGui(Player player, int page) {
        int entries = this.plugin.getSettings().getGuiLayout().getFactionsPerPage();
        SplaySet<FactionWorth> factions = this.plugin.getWorthManager().getOrderedFactions();
        int maxPage = Math.max((int)Math.ceil((double)factions.size() / (double)entries), 1);
        page = Math.max(1, Math.min(maxPage, page));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{page:back}", String.valueOf(page - 1));
        placeholders.put("{page:this}", String.valueOf(page));
        placeholders.put("{page:next}", String.valueOf(page + 1));
        placeholders.put("{page:last}", String.valueOf(maxPage));
        int spacer = entries * (page - 1);
        SplaySet.Iterator<FactionWorth> it = factions.iterator(spacer);
        int lines = this.plugin.getSettings().getGuiLineCount() * 9;
        String name = StringUtils.replace(this.plugin.getSettings().getGuiInventoryName(), placeholders);
        if (name.length() > 32) {
            name = name.substring(0, 32);
        }
        Inventory inventory = this.plugin.getServer().createInventory(null, lines, name);
        GuiContext context = new GuiContext(this.plugin, player, inventory, maxPage, page, it, placeholders);
        context.setCurrentRank(spacer + 1);
        this.plugin.getSettings().getGuiLayout().render(context);
        this.inventories.put(inventory, context);
        player.openInventory(inventory);
    }
}

