/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.listener;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.RecalculateReason;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.BlockPos;
import net.novucs.ftop.entity.ChestWorth;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.hook.event.FactionClaimEvent;
import net.novucs.ftop.hook.event.FactionDisbandEvent;
import net.novucs.ftop.hook.event.FactionEconomyEvent;
import net.novucs.ftop.hook.event.FactionJoinEvent;
import net.novucs.ftop.hook.event.FactionLeaveEvent;
import net.novucs.ftop.hook.event.FactionRenameEvent;
import net.novucs.ftop.hook.event.PlayerEconomyEvent;
import net.novucs.ftop.hook.event.SpawnerMultiplierChangeEvent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WorthListener
extends BukkitRunnable
implements Listener,
PluginService {
    private final FactionsTopPlugin plugin;
    private final Map<BlockPos, ChestWorth> chests = new HashMap<BlockPos, ChestWorth>();
    private final Set<String> recentDisbands = new HashSet<String>();

    public WorthListener(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    @Override
    public void terminate() {
        HandlerList.unregisterAll((Listener)this);
        this.cancel();
    }

    public void run() {
        this.recentDisbands.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(BlockPlaceEvent event) {
        this.updateWorth(event.getBlock(), RecalculateReason.PLACE, false);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(BlockBreakEvent event) {
        this.updateWorth(event.getBlock(), RecalculateReason.BREAK, true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(EntityExplodeEvent event) {
        event.blockList().forEach(block -> this.updateWorth((Block)block, RecalculateReason.EXPLODE, true));
    }

    private void updateWorth(Block block, RecalculateReason reason, boolean negate) {
        String factionId = this.plugin.getFactionsHook().getFactionAt(block);
        if (this.plugin.getSettings().getIgnoredFactionIds().contains(factionId)) {
            return;
        }
        int multiplier = negate ? -1 : 1;
        double price = (double)multiplier * this.plugin.getSettings().getBlockPrice(block.getType());
        WorthType worthType = WorthType.BLOCK;
        HashMap<Material, Integer> materials = new HashMap<Material, Integer>();
        HashMap<EntityType, Integer> spawners = new HashMap<EntityType, Integer>();
        this.plugin.getWorthManager().add(block.getChunk(), reason, worthType, price, (Map<Material, Integer>)ImmutableMap.of((Object)block.getType(), (Object)multiplier), spawners);
        switch (block.getType()) {
            case MOB_SPAWNER: {
                worthType = WorthType.SPAWNER;
                CreatureSpawner spawner = (CreatureSpawner)block.getState();
                EntityType spawnedType = spawner.getSpawnedType();
                price = (double)(multiplier *= this.plugin.getSpawnerStackerHook().getStackSize(spawner)) * this.plugin.getSettings().getSpawnerPrice(spawnedType);
                spawners.put(spawnedType, multiplier);
                break;
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                if (this.plugin.getSettings().isDisableChestEvents()) {
                    return;
                }
                worthType = WorthType.CHEST;
                Chest chest = (Chest)block.getState();
                ChestWorth chestWorth = negate ? this.getWorthNegative(chest.getBlockInventory()) : this.getWorth(chest.getBlockInventory());
                price = chestWorth.getTotalWorth();
                materials.putAll(chestWorth.getMaterials());
                spawners.putAll(chestWorth.getSpawners());
                break;
            }
            default: {
                return;
            }
        }
        this.plugin.getWorthManager().add(block.getChunk(), reason, worthType, price, materials, spawners);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void checkWorth(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player) || this.plugin.getSettings().isDisableChestEvents()) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (inventory.getHolder() instanceof DoubleChest) {
            DoubleChest chest = (DoubleChest)inventory.getHolder();
            this.checkWorth((Chest)chest.getLeftSide());
            this.checkWorth((Chest)chest.getRightSide());
        }
        if (inventory.getHolder() instanceof Chest) {
            this.checkWorth((Chest)inventory.getHolder());
        }
    }

    private void checkWorth(Chest chest) {
        this.chests.put(BlockPos.of(chest.getBlock()), this.getWorth(chest.getBlockInventory()));
    }

    private ChestWorth getWorth(Inventory inventory) {
        double worth = 0.0;
        HashMap<Material, Integer> materials = new HashMap<Material, Integer>();
        HashMap<EntityType, Integer> spawners = new HashMap<EntityType, Integer>();
        for (ItemStack item : inventory.getContents()) {
            if (item == null) continue;
            if (item.getType() == Material.MOB_SPAWNER) {
                int stackSize = this.plugin.getSpawnerStackerHook().getStackSize(item);
                EntityType spawnerType = this.plugin.getSpawnerStackerHook().getSpawnedType(item);
                worth += this.plugin.getSettings().getSpawnerPrice(spawnerType) * (double)item.getAmount() * (double)stackSize;
                int count = spawners.getOrDefault(spawnerType, 0);
                spawners.put(spawnerType, count + item.getAmount() * stackSize);
                continue;
            }
            worth += this.plugin.getSettings().getBlockPrice(item.getType()) * (double)item.getAmount();
            int count = materials.getOrDefault(item.getType(), 0);
            materials.put(item.getType(), count + item.getAmount());
        }
        return new ChestWorth(worth, materials, spawners);
    }

    private ChestWorth getWorthNegative(Inventory inventory) {
        double worth = 0.0;
        HashMap<Material, Integer> materials = new HashMap<Material, Integer>();
        HashMap<EntityType, Integer> spawners = new HashMap<EntityType, Integer>();
        for (ItemStack item : inventory.getContents()) {
            if (item == null) continue;
            if (item.getType() == Material.MOB_SPAWNER) {
                int stackSize = this.plugin.getSpawnerStackerHook().getStackSize(item);
                EntityType spawnerType = this.plugin.getSpawnerStackerHook().getSpawnedType(item);
                worth -= this.plugin.getSettings().getSpawnerPrice(spawnerType) * (double)item.getAmount() * (double)stackSize;
                int count = spawners.getOrDefault(spawnerType, 0);
                spawners.put(spawnerType, count - (item.getAmount() + stackSize));
                continue;
            }
            worth -= this.plugin.getSettings().getBlockPrice(item.getType()) * (double)item.getAmount();
            int count = materials.getOrDefault(item.getType(), 0);
            materials.put(item.getType(), count - item.getAmount());
        }
        return new ChestWorth(worth, materials, spawners);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player) || this.plugin.getSettings().isDisableChestEvents()) {
            return;
        }
        if (event.getInventory().getHolder() instanceof DoubleChest) {
            DoubleChest chest = (DoubleChest)event.getInventory().getHolder();
            this.updateWorth((Chest)chest.getLeftSide());
            this.updateWorth((Chest)chest.getRightSide());
        }
        if (event.getInventory().getHolder() instanceof Chest) {
            this.updateWorth((Chest)event.getInventory().getHolder());
        }
    }

    private void updateWorth(Chest chest) {
        if (chest == null) {
            return;
        }
        BlockPos pos = BlockPos.of(chest.getBlock());
        ChestWorth worth = this.chests.remove(pos);
        if (worth == null) {
            return;
        }
        worth = this.getDifference(worth, this.getWorth(chest.getBlockInventory()));
        this.plugin.getWorthManager().add(chest.getChunk(), RecalculateReason.CHEST, WorthType.CHEST, worth.getTotalWorth(), worth.getMaterials(), worth.getSpawners());
    }

    private ChestWorth getDifference(ChestWorth first, ChestWorth second) {
        double worth = second.getTotalWorth() - first.getTotalWorth();
        Map<Material, Integer> materials = this.getDifference(first.getMaterials(), second.getMaterials());
        Map<EntityType, Integer> spawners = this.getDifference(first.getSpawners(), second.getSpawners());
        return new ChestWorth(worth, materials, spawners);
    }

    private <T> Map<T, Integer> getDifference(Map<T, Integer> first, Map<T, Integer> second) {
        HashMap<T, Integer> target = new HashMap<T, Integer>();
        for (Map.Entry<T, Integer> entry : first.entrySet()) {
            int difference = second.getOrDefault(entry.getKey(), 0) - entry.getValue();
            target.put(entry.getKey(), difference);
        }
        for (Map.Entry<T, Integer> entry : second.entrySet()) {
            if (target.containsKey(entry.getKey())) continue;
            target.put(entry.getKey(), entry.getValue());
        }
        return target;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(FactionClaimEvent event) {
        String newFactionId = event.getFactionId();
        event.getClaims().asMap().forEach((oldFactionId, claims) -> {
            if (!oldFactionId.equals(newFactionId)) {
                this.plugin.getWorthManager().update(newFactionId, (Collection<ChunkPos>)claims, false);
                this.plugin.getWorthManager().update((String)oldFactionId, (Collection<ChunkPos>)claims, true);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void removeFaction(FactionDisbandEvent event) {
        this.recentDisbands.add(event.getFactionId());
        this.plugin.getWorthManager().remove(event.getFactionId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void renameFaction(FactionRenameEvent event) {
        this.plugin.getWorthManager().rename(event.getFactionId(), event.getNewName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(FactionEconomyEvent event) {
        this.plugin.getWorthManager().add(event.getFactionId(), WorthType.FACTION_BALANCE, event.getNewBalance() - event.getOldBalance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(PlayerEconomyEvent event) {
        String factionId = this.plugin.getFactionsHook().getFaction(event.getPlayer());
        this.plugin.getWorthManager().add(factionId, WorthType.PLAYER_BALANCE, event.getNewBalance() - event.getOldBalance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(FactionJoinEvent event) {
        double balance = this.plugin.getEconomyHook().getBalance(event.getPlayer());
        this.plugin.getWorthManager().add(event.getFactionId(), WorthType.PLAYER_BALANCE, balance);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(FactionLeaveEvent event) {
        if (this.recentDisbands.contains(event.getFactionId())) {
            return;
        }
        double balance = this.plugin.getEconomyHook().getBalance(event.getPlayer());
        this.plugin.getWorthManager().add(event.getFactionId(), WorthType.PLAYER_BALANCE, -balance);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void recalculate(ChunkUnloadEvent event) {
        this.plugin.getWorthManager().recalculate(event.getChunk(), RecalculateReason.UNLOAD);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(SpawnerMultiplierChangeEvent event) {
        Block block = event.getBlock();
        String factionId = this.plugin.getFactionsHook().getFactionAt(block);
        if (this.plugin.getSettings().getIgnoredFactionIds().contains(factionId)) {
            return;
        }
        int difference = event.getNewMultiplier() - event.getOldMultiplier();
        WorthType worthType = WorthType.SPAWNER;
        HashMap<Material, Integer> materials = new HashMap<Material, Integer>();
        HashMap<EntityType, Integer> spawners = new HashMap<EntityType, Integer>();
        EntityType spawnType = ((CreatureSpawner)block.getState()).getSpawnedType();
        double price = (double)difference * this.plugin.getSettings().getSpawnerPrice(spawnType);
        spawners.put(spawnType, difference);
        RecalculateReason reason = difference > 0 ? RecalculateReason.PLACE : RecalculateReason.BREAK;
        this.plugin.getWorthManager().add(block.getChunk(), reason, worthType, price, materials, spawners);
    }
}

