/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.listener;

import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.entity.FactionWorth;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener,
PluginService {
    private static final String RANK_PLACEHOLDER = "{rank}";
    private final FactionsTopPlugin plugin;

    public ChatListener(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void terminate() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void replacePlaceholders(AsyncPlayerChatEvent event) {
        if (!this.plugin.getSettings().isChatEnabled()) {
            return;
        }
        String placeholder = this.plugin.getSettings().getChatRankPlaceholder();
        if (!event.getFormat().contains(placeholder)) {
            return;
        }
        String factionId = this.plugin.getFactionsHook().getFaction(event.getPlayer());
        String format = event.getFormat();
        if (this.plugin.getSettings().getIgnoredFactionIds().contains(factionId)) {
            event.setFormat(format.replace(placeholder, this.plugin.getSettings().getChatRankNotFound()));
            return;
        }
        FactionWorth worth = this.plugin.getWorthManager().getWorth(factionId);
        int rank = this.plugin.getWorthManager().getOrderedFactions().indexOf(worth) + 1;
        if (rank == 0) {
            event.setFormat(format.replace(placeholder, this.plugin.getSettings().getChatRankNotFound()));
            return;
        }
        String rankFound = this.plugin.getSettings().getChatRankFound().replace(RANK_PLACEHOLDER, String.valueOf(rank));
        format = format.replace(placeholder, rankFound);
        event.setFormat(format);
    }
}

