/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.hook;

import com.songoda.epicspawners.API.EpicSpawnersAPI;
import com.songoda.epicspawners.EpicSpawners;
import com.songoda.epicspawners.Spawners.SpawnerChangeEvent;
import net.novucs.ftop.hook.CraftbukkitHook;
import net.novucs.ftop.hook.SpawnerStackerHook;
import net.novucs.ftop.hook.event.SpawnerMultiplierChangeEvent;
import org.bukkit.ChatColor;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EpicSpawnersHook
implements SpawnerStackerHook,
Listener {
    private final Plugin plugin;
    private final CraftbukkitHook craftbukkitHook;
    private EpicSpawnersAPI api;

    public EpicSpawnersHook(Plugin plugin, CraftbukkitHook craftbukkitHook) {
        this.plugin = plugin;
        this.craftbukkitHook = craftbukkitHook;
    }

    @Override
    public void initialize() {
        Plugin epicSpawnersPlugin = this.plugin.getServer().getPluginManager().getPlugin("EpicSpawners");
        if (epicSpawnersPlugin instanceof EpicSpawners) {
            this.api = ((EpicSpawners)epicSpawnersPlugin).getApi();
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        }
    }

    @Override
    public EntityType getSpawnedType(ItemStack spawner) {
        if (this.api == null) {
            return this.craftbukkitHook.getSpawnerType(spawner);
        }
        try {
            return this.api.getType(spawner);
        }
        catch (IllegalArgumentException ex) {
            return this.craftbukkitHook.getSpawnerType(spawner);
        }
    }

    @Override
    public int getStackSize(ItemStack spawner) {
        if (this.api == null || !spawner.hasItemMeta()) {
            return 1;
        }
        String[] args = spawner.getItemMeta().getDisplayName().split(" ");
        String lastArg = ChatColor.stripColor((String)args[args.length - 1]);
        if (lastArg.length() > 0) {
            lastArg = lastArg.substring(0, lastArg.length() - 1);
        }
        try {
            return Integer.parseInt(lastArg);
        }
        catch (NumberFormatException ex) {
            return 1;
        }
    }

    @Override
    public int getStackSize(CreatureSpawner spawner) {
        if (this.api == null) {
            return 1;
        }
        return this.api.getSpawnerMultiplier(spawner.getLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void updateWorth(SpawnerChangeEvent event) {
        CreatureSpawner spawner = (CreatureSpawner)event.getSpawner().getState();
        int oldMultiplier = event.getOldMulti();
        int newMultiplier = event.getCurrentMulti();
        SpawnerMultiplierChangeEvent event1 = new SpawnerMultiplierChangeEvent(spawner, oldMultiplier, newMultiplier);
        if (this.plugin.getServer().isPrimaryThread()) {
            this.plugin.getServer().getPluginManager().callEvent((Event)event1);
            return;
        }
        this.plugin.getServer().getScheduler().runTask(this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)event1));
    }
}

