/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.gui.element.button;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiButtonContent {
    private final String text;
    private final List<String> lore;
    private final Material material;
    private final byte data;
    private ItemStack item;

    private GuiButtonContent(String text, List<String> lore, Material material, byte data) {
        this.text = text;
        this.lore = lore;
        this.material = material;
        this.data = data;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public Material getMaterial() {
        return this.material;
    }

    public byte getData() {
        return this.data;
    }

    public ItemStack getItem() {
        if (this.item == null) {
            this.item = new ItemStack(this.material, 1, (short)this.data);
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(this.text);
            meta.setLore(this.lore);
            this.item.setItemMeta(meta);
        }
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiButtonContent that = (GuiButtonContent)o;
        return this.data == that.data && Objects.equals(this.text, that.text) && Objects.equals(this.lore, that.lore) && this.material == that.material;
    }

    public int hashCode() {
        return Objects.hash(this.text, this.lore, this.material, this.data);
    }

    public String toString() {
        return "GuiButtonContent{text='" + this.text + '\'' + ", lore=" + this.lore + ", material=" + this.material + ", data=" + this.data + '}';
    }

    public static class Builder {
        private String text;
        private List<String> lore = new ArrayList<String>();
        private Material material = Material.AIR;
        private byte data = 0;

        public void text(String text) {
            this.text = text;
        }

        public void lore(List<String> lore) {
            this.lore = lore;
        }

        public void material(Material material) {
            this.material = material;
        }

        public void data(byte data) {
            this.data = data;
        }

        public GuiButtonContent build() {
            return new GuiButtonContent(this.text, this.lore, this.material, this.data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.data == builder.data && Objects.equals(this.text, builder.text) && Objects.equals(this.lore, builder.lore) && this.material == builder.material;
        }

        public int hashCode() {
            return Objects.hash(this.text, this.lore, this.material, this.data);
        }

        public String toString() {
            return "Builder{text='" + this.text + '\'' + ", lore=" + this.lore + ", material=" + this.material + ", data=" + this.data + '}';
        }
    }
}

