/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.gui.element;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.Settings;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.gui.GuiContext;
import net.novucs.ftop.gui.element.GuiElement;
import net.novucs.ftop.util.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GuiFactionList
implements GuiElement {
    private final int factionCount;
    private final boolean fillEmpty;
    private final String text;
    private final List<String> lore;

    private GuiFactionList(int factionCount, boolean fillEmpty, String text, List<String> lore) {
        this.factionCount = factionCount;
        this.fillEmpty = fillEmpty;
        this.text = text;
        this.lore = lore;
    }

    @Override
    public void render(GuiContext context) {
        FactionsTopPlugin plugin = context.getPlugin();
        DecimalFormat currencyFormat = plugin.getSettings().getCurrencyFormat();
        DecimalFormat countFormat = plugin.getSettings().getCountFormat();
        int counter = 0;
        while (counter++ < this.factionCount && context.getInventory().getSize() > context.getSlot()) {
            context.getSlots().add(this);
            if (!context.getWorthIterator().hasNext()) {
                if (!this.fillEmpty) break;
                context.getAndIncrementSlot();
                continue;
            }
            FactionWorth worth = (FactionWorth)context.getWorthIterator().next();
            HashMap<String, String> placeholders = new HashMap<String, String>(context.getPlaceholders());
            placeholders.put("{rank}", Integer.toString(context.getAndIncrementRank()));
            placeholders.put("{relcolor}", "\u00a7" + StringUtils.getRelationColor(plugin, (CommandSender)context.getPlayer(), worth.getFactionId()).getChar());
            placeholders.put("{faction}", worth.getName());
            placeholders.put("{worth:total}", currencyFormat.format(worth.getTotalWorth()));
            placeholders.put("{count:total:spawner}", countFormat.format(worth.getTotalSpawnerCount()));
            String owner = plugin.getFactionsHook().getOwnerName(worth.getFactionId());
            ItemStack item = this.getItem(worth, placeholders, plugin.getSettings(), owner);
            context.getInventory().setItem(context.getAndIncrementSlot(), item);
        }
    }

    @Override
    public void handleClick(GuiContext context) {
    }

    public int getFactionCount() {
        return this.factionCount;
    }

    private ItemStack getItem(FactionWorth worth, Map<String, String> placeholders, Settings settings, String owner) {
        String text = StringUtils.insertPlaceholders(settings, worth, StringUtils.replace(this.text, placeholders));
        List<String> lore = StringUtils.insertPlaceholders(settings, worth, StringUtils.replace(this.lore, placeholders));
        ItemStack item = new ItemStack(Material.SKULL_ITEM, 1, 3);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setDisplayName(text);
        meta.setLore(lore);
        meta.setOwner(owner);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiFactionList that = (GuiFactionList)o;
        return this.factionCount == that.factionCount && this.fillEmpty == that.fillEmpty && Objects.equals(this.text, that.text) && Objects.equals(this.lore, that.lore);
    }

    public int hashCode() {
        return Objects.hash(this.factionCount, this.fillEmpty, this.text, this.lore);
    }

    public String toString() {
        return "GuiFactionList{factionCount=" + this.factionCount + ", fillEmpty=" + this.fillEmpty + ", text='" + this.text + '\'' + ", lore=" + this.lore + '}';
    }

    public static class Builder {
        private int factionCount = 0;
        private boolean fillEmpty = true;
        private String text = "";
        private List<String> lore = new ArrayList<String>();

        public void factionCount(int factionCount) {
            this.factionCount = factionCount;
        }

        public void fillEmpty(boolean fillEmpty) {
            this.fillEmpty = fillEmpty;
        }

        public void text(String text) {
            this.text = text;
        }

        public void lore(List<String> lore) {
            this.lore = lore;
        }

        public GuiFactionList build() {
            return new GuiFactionList(this.factionCount, this.fillEmpty, this.text, this.lore);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.factionCount == builder.factionCount && this.fillEmpty == builder.fillEmpty && Objects.equals(this.text, builder.text) && Objects.equals(this.lore, builder.lore);
        }

        public int hashCode() {
            return Objects.hash(this.factionCount, this.fillEmpty, this.text, this.lore);
        }

        public String toString() {
            return "Builder{factionCount=" + this.factionCount + ", fillEmpty=" + this.fillEmpty + ", text='" + this.text + '\'' + ", lore=" + this.lore + '}';
        }
    }
}

