/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.gui.element;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.novucs.ftop.gui.element.ElementParser;
import net.novucs.ftop.gui.element.GuiFactionList;
import net.novucs.ftop.gui.element.button.GuiBackButton;
import net.novucs.ftop.gui.element.button.GuiButtonContent;
import net.novucs.ftop.gui.element.button.GuiNextButton;
import net.novucs.ftop.util.GenericUtils;
import net.novucs.ftop.util.StringUtils;
import org.bukkit.Material;

public enum GuiElementType {
    FACTION_LIST(GuiElementType::parseFactionList),
    BUTTON_BACK(data -> new GuiBackButton(GuiElementType.parseButton(GenericUtils.getMap(data, "enabled").orElse(Collections.emptyMap())), GuiElementType.parseButton(GenericUtils.getMap(data, "disabled").orElse(Collections.emptyMap())))),
    BUTTON_NEXT(data -> new GuiNextButton(GuiElementType.parseButton(GenericUtils.getMap(data, "enabled").orElse(Collections.emptyMap())), GuiElementType.parseButton(GenericUtils.getMap(data, "disabled").orElse(Collections.emptyMap()))));

    private final ElementParser parser;

    private GuiElementType(ElementParser parser) {
        this.parser = parser;
    }

    public ElementParser getParser() {
        return this.parser;
    }

    private static GuiFactionList parseFactionList(Map<?, ?> element) {
        Optional<List> lore;
        Optional<String> text;
        Optional<Boolean> fillEmpty;
        GuiFactionList.Builder builder = new GuiFactionList.Builder();
        Optional<Integer> factionCount = GenericUtils.getInt(element, "faction-count");
        if (factionCount.isPresent()) {
            builder.factionCount(factionCount.get());
        }
        if ((fillEmpty = GenericUtils.getBoolean(element, "fill-empty")).isPresent()) {
            builder.fillEmpty(fillEmpty.get());
        }
        if ((text = GenericUtils.getString(element, "text")).isPresent()) {
            builder.text(StringUtils.format(text.get()));
        }
        if ((lore = GenericUtils.getList(element, "lore")).isPresent()) {
            builder.lore(StringUtils.format(GenericUtils.castList(String.class, lore.get())));
        }
        return builder.build();
    }

    private static GuiButtonContent parseButton(Map<?, ?> element) {
        Optional<Integer> data;
        Optional<Material> material;
        Optional<List> lore;
        GuiButtonContent.Builder builder = new GuiButtonContent.Builder();
        Optional<String> text = GenericUtils.getString(element, "text");
        if (text.isPresent()) {
            builder.text(StringUtils.format(text.get()));
        }
        if ((lore = GenericUtils.getList(element, "lore")).isPresent()) {
            builder.lore(StringUtils.format(GenericUtils.castList(String.class, lore.get())));
        }
        if ((material = GenericUtils.getMaterial(element, "material")).isPresent()) {
            builder.material(material.get());
        }
        if ((data = GenericUtils.getInt(element, "data")).isPresent()) {
            builder.data(data.get().byteValue());
        }
        return builder.build();
    }
}

